/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.ReilOperand;
import com.google.security.zynamics.reil.ReilOperandNode;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.TranslationResultType;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.ArrayList;
import java.util.List;

public class CmpxchgTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        String xaxRegister;
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "cmpxchg");
        Preconditions.checkArgument(instruction.getOperands().size() == 2, "Error: Argument instruction is not a cmp instruction (invalid number of operands)");
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        IOperandTree targetOperand = operands.get(0);
        IOperandTree sourceOperand = operands.get(1);
        TranslationResult targetResult = Helpers.translateOperand(environment, offset, targetOperand, true);
        instructions.addAll(targetResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult sourceResult = Helpers.translateOperand(environment, offset, sourceOperand, true);
        instructions.addAll(sourceResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        switch (targetResult.getSize()) {
            case BYTE: {
                xaxRegister = "al";
                break;
            }
            case WORD: {
                xaxRegister = "ax";
                break;
            }
            case DWORD: {
                xaxRegister = "eax";
                break;
            }
            default: {
                throw new InternalTranslationException("Error: The first operand has to be BYTE/WORD/DWORD !");
            }
        }
        String comparisonResult = environment.getNextVariableString();
        OperandSize currentSize = targetResult.getSize();
        instructions.add(ReilHelpers.createSub(baseOffset + (long)instructions.size(), currentSize, xaxRegister, currentSize, targetResult.getRegister(), currentSize, comparisonResult));
        instructions.add(ReilHelpers.createBisz(baseOffset + (long)instructions.size(), currentSize, comparisonResult, OperandSize.BYTE, "ZF"));
        ArrayList<ReilInstruction> firstWriteBack = new ArrayList<ReilInstruction>();
        Helpers.writeBack(environment, baseOffset + (long)instructions.size() + 1L, targetOperand, sourceResult.getRegister(), sourceResult.getSize(), targetResult.getAddress(), targetResult.getType(), firstWriteBack);
        long secondWriteBackOffset = instructions.size() + firstWriteBack.size() + 3;
        String secondWriteBackGoal = String.format("%d.%d", instruction.getAddress().toLong(), secondWriteBackOffset);
        instructions.add(ReilHelpers.createJcc(baseOffset + (long)instructions.size(), currentSize, comparisonResult, OperandSize.ADDRESS, secondWriteBackGoal, new String[0]));
        instructions.addAll(firstWriteBack);
        ReilOperandNode xAXOperandRoot = new ReilOperandNode(currentSize.toSizeString(), ExpressionType.SIZE_PREFIX);
        ReilOperandNode xAXOperandLeaf = new ReilOperandNode(xaxRegister, ExpressionType.REGISTER);
        ReilOperandNode.link(xAXOperandRoot, xAXOperandLeaf);
        ReilOperand xAXOperand = new ReilOperand(xAXOperandRoot);
        ArrayList<ReilInstruction> secondWriteBack = new ArrayList<ReilInstruction>();
        Helpers.writeBack(environment, baseOffset + (long)instructions.size() + 1L, xAXOperand, targetResult.getRegister(), currentSize, null, TranslationResultType.REGISTER, secondWriteBack);
        long terminatingNopOffset = instructions.size() + secondWriteBack.size() + 2;
        String terminatingNopGoal = String.format("%d.%d", instruction.getAddress().toLong(), terminatingNopOffset);
        instructions.add(ReilHelpers.createJcc(baseOffset + (long)instructions.size(), OperandSize.BYTE, "1", OperandSize.ADDRESS, terminatingNopGoal, new String[0]));
        instructions.addAll(secondWriteBack);
        instructions.add(ReilHelpers.createNop(baseOffset + (long)instructions.size()));
    }
}

