/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.reil.translators.x86.IConditionGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.ArrayList;
import java.util.List;

public class CmovccTranslator
implements IInstructionTranslator {
    private final IConditionGenerator conditionGenerator;

    public CmovccTranslator(IConditionGenerator conditionGenerator) {
        this.conditionGenerator = Preconditions.checkNotNull(conditionGenerator, "Error: Argument conditionGenerator can't be null");
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instruction, "Error: Argument instruction can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        Preconditions.checkArgument(instruction.getOperands().size() == 2, "Error: Argument instruction is not a conditional move instruction (invalid number of operands)");
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        Pair<OperandSize, String> conditionResult = this.conditionGenerator.generate(environment, offset, instructions);
        OperandSize conditionRegisterSize = conditionResult.first();
        String conditionRegister = conditionResult.second();
        offset = baseOffset + (long)instructions.size();
        String flippedCondition = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBisz(offset, conditionRegisterSize, conditionRegister, OperandSize.BYTE, flippedCondition));
        ArrayList<ReilInstruction> movCode = new ArrayList<ReilInstruction>();
        Helpers.generateMov(environment, offset + 2L, instruction, movCode);
        long lastOffset = instructions.size() + movCode.size() + 1;
        String jmpGoal = String.format("%d.%d", instruction.getAddress().toLong(), lastOffset);
        instructions.add(ReilHelpers.createJcc(offset + 1L, OperandSize.BYTE, flippedCondition, OperandSize.ADDRESS, jmpGoal, new String[0]));
        instructions.addAll(movCode);
        offset = baseOffset + (long)instructions.size();
        instructions.add(ReilHelpers.createNop(offset));
    }
}

