/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class CallTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "call");
        if (instruction.getOperands().size() != 1) {
            throw new InternalTranslationException("Error: Argument instruction is not a call instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        OperandSize archSize = environment.getArchitectureSize();
        OperandSize nextSize = TranslationHelpers.getNextSize(archSize);
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(archSize));
        String tempEsp = environment.getNextVariableString();
        String returnAddress = String.valueOf(instruction.getAddress().toLong() + instruction.getLength());
        instructions.add(ReilHelpers.createSub(offset, archSize, "esp", archSize, "4", nextSize, tempEsp));
        instructions.add(ReilHelpers.createAnd(offset + 1L, nextSize, tempEsp, archSize, truncateMask, archSize, "esp"));
        instructions.add(ReilHelpers.createStm(offset + 2L, archSize, returnAddress, archSize, "esp"));
        IOperandTree targetOperand = instruction.getOperands().get(0);
        TranslationResult result = Helpers.translateOperand(environment, offset + 3L, targetOperand, true);
        instructions.addAll(result.getInstructions());
        offset = baseOffset + (long)instructions.size();
        instructions.add(ReilHelpers.createJcc(offset, OperandSize.DWORD, "1", result.getSize(), result.getRegister(), "isCall", "true"));
    }
}

