/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class BswapTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "bswap");
        if (instruction.getOperands().size() != 1) {
            throw new InternalTranslationException("Error: Argument instruction is not a lahf instruction (invalid number of operands)");
        }
        long baseOffset = instruction.getAddress().toLong() * 256L;
        OperandSize archSize = environment.getArchitectureSize();
        String operand = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String masked1st = environment.getNextVariableString();
        String masked2nd = environment.getNextVariableString();
        String masked3rd = environment.getNextVariableString();
        String masked4th = environment.getNextVariableString();
        String shifted1st = environment.getNextVariableString();
        String shifted2nd = environment.getNextVariableString();
        String shifted3rd = environment.getNextVariableString();
        String shifted4th = environment.getNextVariableString();
        String combined1 = environment.getNextVariableString();
        String combined2 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(baseOffset + 0L, archSize, operand, archSize, "255", archSize, masked1st));
        instructions.add(ReilHelpers.createAnd(baseOffset + 1L, archSize, operand, archSize, "65280", archSize, masked2nd));
        instructions.add(ReilHelpers.createAnd(baseOffset + 2L, archSize, operand, archSize, "16711680", archSize, masked3rd));
        instructions.add(ReilHelpers.createAnd(baseOffset + 3L, archSize, operand, archSize, "4278190080", archSize, masked4th));
        instructions.add(ReilHelpers.createBsh(baseOffset + 4L, archSize, masked1st, archSize, "24", archSize, shifted1st));
        instructions.add(ReilHelpers.createBsh(baseOffset + 5L, archSize, masked2nd, archSize, "8", archSize, shifted2nd));
        instructions.add(ReilHelpers.createBsh(baseOffset + 6L, archSize, masked3rd, archSize, "-8", archSize, shifted3rd));
        instructions.add(ReilHelpers.createBsh(baseOffset + 7L, archSize, masked4th, archSize, "-24", archSize, shifted4th));
        instructions.add(ReilHelpers.createOr(baseOffset + 8L, archSize, shifted1st, archSize, shifted2nd, archSize, combined1));
        instructions.add(ReilHelpers.createOr(baseOffset + 9L, archSize, shifted3rd, archSize, shifted4th, archSize, combined2));
        instructions.add(ReilHelpers.createOr(baseOffset + 10L, archSize, combined1, archSize, combined2, archSize, operand));
    }
}

