/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.x86.IConditionGenerator;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class AboveGenerator
implements IConditionGenerator {
    @Override
    public Pair<OperandSize, String> generate(ITranslationEnvironment environment, long offset, List<ReilInstruction> instructions) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        Preconditions.checkArgument(offset >= 0L, "Error: Argument offset can't be less than 0");
        String zfZero = environment.getNextVariableString();
        String cfZero = environment.getNextVariableString();
        String bothZero = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBisz(offset, OperandSize.BYTE, "ZF", OperandSize.BYTE, zfZero));
        instructions.add(ReilHelpers.createBisz(offset + 1L, OperandSize.BYTE, "CF", OperandSize.BYTE, cfZero));
        instructions.add(ReilHelpers.createAnd(offset + 2L, OperandSize.BYTE, zfZero, OperandSize.BYTE, cfZero, OperandSize.BYTE, bothZero));
        return new Pair<OperandSize, String>(OperandSize.BYTE, bothZero);
    }
}

