/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.ppc.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class StswiTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        Long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "stswi");
        IOperandTreeNode countRegister = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode addressRegister = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode numBytes = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        OperandSize dw = OperandSize.DWORD;
        String effectiveAddress = environment.getNextVariableString();
        String tmpData = environment.getNextVariableString();
        Long l2 = baseOffset = Long.valueOf(instruction.getAddress().toLong() * 256L);
        Long l3 = baseOffset = Long.valueOf(baseOffset + 1L);
        instructions.add(ReilHelpers.createAnd(l2, dw, addressRegister.getValue(), dw, String.valueOf(0xFFFFFFFFL), dw, effectiveAddress));
        int r2 = Helpers.getRegisterIndex(countRegister.getValue()) - 1;
        for (int n2 = numBytes.getValue() == "0" ? 32 : Integer.decode(numBytes.getValue()); n2 > 0; n2 -= 4) {
            Long l4;
            r2 = (r2 + 1) % 32;
            if (n2 == 3) {
                l3 = baseOffset;
                l4 = baseOffset = Long.valueOf(baseOffset + 1L);
                int n3 = r2;
                instructions.add(ReilHelpers.createAnd(l3, dw, Helpers.getRealRegisterName(new StringBuilder(12).append("r").append(n3).toString()), dw, String.valueOf(0xFFFFFF00L), dw, tmpData));
            } else if (n2 == 2) {
                l3 = baseOffset;
                l4 = baseOffset = Long.valueOf(baseOffset + 1L);
                int n4 = r2;
                instructions.add(ReilHelpers.createAnd(l3, dw, Helpers.getRealRegisterName(new StringBuilder(12).append("r").append(n4).toString()), dw, String.valueOf(0xFFFF0000L), dw, tmpData));
            } else if (n2 == 1) {
                l3 = baseOffset;
                l4 = baseOffset = Long.valueOf(baseOffset + 1L);
                int n5 = r2;
                instructions.add(ReilHelpers.createAnd(l3, dw, Helpers.getRealRegisterName(new StringBuilder(12).append("r").append(n5).toString()), dw, String.valueOf(0xFF000000L), dw, tmpData));
            } else {
                l3 = baseOffset;
                l4 = baseOffset = Long.valueOf(baseOffset + 1L);
                int n6 = r2;
                instructions.add(ReilHelpers.createStr(l3, dw, Helpers.getRealRegisterName(new StringBuilder(12).append("r").append(n6).toString()), dw, tmpData));
                Long l5 = baseOffset;
                l4 = baseOffset = Long.valueOf(baseOffset + 1L);
                instructions.add(ReilHelpers.createAdd(l5, dw, effectiveAddress, dw, String.valueOf(4L), dw, effectiveAddress));
            }
            l3 = baseOffset;
            l4 = baseOffset = Long.valueOf(baseOffset + 1L);
            instructions.add(ReilHelpers.createStm(l3, dw, tmpData, dw, effectiveAddress));
        }
    }
}

