/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.ppc.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class RlwnmGenerator {
    public static void generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic, boolean isSimplified, boolean setCr) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, mnemonic);
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode integerOperand1 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        IOperandTreeNode integerOperand2 = instruction.getOperands().size() <= 3 && isSimplified ? null : instruction.getOperands().get(3).getRootNode().getChildren().get(0);
        IOperandTreeNode integerOperand3 = instruction.getOperands().size() <= 4 && isSimplified ? null : instruction.getOperands().get(4).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister = registerOperand2.getValue();
        String SH = environment.getNextVariableString();
        String SH2 = environment.getNextVariableString();
        String MB = "";
        String ME = "";
        String crTemp = environment.getNextVariableString();
        String rotateVar1 = environment.getNextVariableString();
        String rotateVar2 = environment.getNextVariableString();
        String rotateVar3 = environment.getNextVariableString();
        String rotateVar4 = environment.getNextVariableString();
        if (isSimplified) {
            if (instruction.getMnemonic().equals("rotlw") || instruction.getMnemonic().equals("rotlw.")) {
                MB = String.valueOf(0L);
                ME = String.valueOf(31L);
            }
        } else {
            MB = integerOperand2.getValue();
            ME = integerOperand3.getValue();
        }
        String normalMask = instruction.getOperands().size() == 4 && !isSimplified ? integerOperand2.getValue() : Helpers.getRotateMask(MB, ME);
        OperandSize dw = OperandSize.DWORD;
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, integerOperand1.getValue(), dw, String.valueOf(31L), dw, SH));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, SH, dw, String.valueOf(32L), dw, SH2));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, dw, SH, dw, rotateVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, dw, SH2, dw, rotateVar2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, rotateVar1, dw, rotateVar2, dw, rotateVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, rotateVar3, dw, String.valueOf(0xFFFFFFFFL), dw, rotateVar4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, rotateVar4, dw, normalMask, dw, targetRegister));
        if (setCr) {
            instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.BYTE, "CR0EQ"));
            instructions.add(ReilHelpers.createBsh(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.WORD, "-31", OperandSize.BYTE, "CR0LT"));
            instructions.add(ReilHelpers.createOr(baseOffset++, OperandSize.BYTE, "CR0EQ", OperandSize.BYTE, "CR0LT", OperandSize.BYTE, crTemp));
            instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.BYTE, crTemp, OperandSize.BYTE, "CR0GT"));
            instructions.add(ReilHelpers.createStr(baseOffset, OperandSize.BYTE, "XERSO", OperandSize.BYTE, "CR0SO"));
        }
    }
}

