/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.ppc.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class MtocrfTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "mtocrf");
        IOperandTreeNode sourceRegister = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode crMask = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        Long baseOffset = instruction.getAddress().toLong() * 256L;
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        String maskVar1 = environment.getNextVariableString();
        String andVar1 = environment.getNextVariableString();
        String andVar2 = environment.getNextVariableString();
        String andVar3 = environment.getNextVariableString();
        String orVar1 = environment.getNextVariableString();
        String orVar2 = environment.getNextVariableString();
        String inverseMask = environment.getNextVariableString();
        Long l2 = baseOffset;
        Long l3 = baseOffset = Long.valueOf(baseOffset + 1L);
        instructions.add(ReilHelpers.createAnd(l2, dw, sourceRegister.getValue(), dw, Helpers.getCRM(Integer.decode(crMask.getValue())), dw, maskVar1));
        l2 = baseOffset;
        l3 = baseOffset = Long.valueOf(baseOffset + 1L);
        instructions.add(ReilHelpers.createXor(l2, dw, Helpers.getCRM(Integer.decode(crMask.getValue())), dw, String.valueOf(0xFFFFFFFFL), dw, inverseMask));
        for (int i2 = 0; i2 < 31; ++i2) {
            l3 = baseOffset;
            Long l4 = baseOffset = Long.valueOf(baseOffset + 1L);
            instructions.add(ReilHelpers.createBsh(l3, dw, inverseMask, bt2, String.valueOf(i2 - 31), dw, andVar2));
            l3 = baseOffset;
            l4 = baseOffset = Long.valueOf(baseOffset + 1L);
            instructions.add(ReilHelpers.createAnd(l3, dw, andVar2, dw, String.valueOf(1L), dw, andVar3));
            l3 = baseOffset;
            l4 = baseOffset = Long.valueOf(baseOffset + 1L);
            instructions.add(ReilHelpers.createAnd(l3, bt2, Helpers.getCRBit(i2), bt2, andVar3, bt2, orVar1));
            l3 = baseOffset;
            l4 = baseOffset = Long.valueOf(baseOffset + 1L);
            instructions.add(ReilHelpers.createBsh(l3, dw, maskVar1, bt2, String.valueOf(i2 - 31), dw, andVar1));
            l3 = baseOffset;
            l4 = baseOffset = Long.valueOf(baseOffset + 1L);
            instructions.add(ReilHelpers.createAnd(l3, dw, andVar1, dw, String.valueOf(1L), dw, orVar2));
            l3 = baseOffset;
            l4 = baseOffset = Long.valueOf(baseOffset + 1L);
            instructions.add(ReilHelpers.createOr(l3, bt2, orVar1, bt2, orVar2, bt2, Helpers.getCRBit(i2)));
        }
    }
}

