/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

public class Helpers {
    public static final String CR0_LESS_THEN = "CR0LT";
    public static final String CR0_GREATER_THEN = "CR0GT";
    public static final String CR0_EQUAL = "CR0EQ";
    public static final String CRO_SUMMARY_OVERFLOW = "CR0SO";
    public static final String XER_SUMMARY_OVERFLOW = "XERSO";
    public static final String XER_OVERFLOW = "XEROV";
    public static final String XER_CARRY_BIT = "XERCA";
    public static final String XER_COUNT_REGISTER = "XERBC";
    public static final String LINK_REGISTER = "lr";
    public static final String COUNT_REGISTER = "ctr";

    public static String getCRBit(int index) {
        switch (index) {
            case 0: {
                return CR0_LESS_THEN;
            }
            case 1: {
                return CR0_GREATER_THEN;
            }
            case 2: {
                return CR0_EQUAL;
            }
            case 3: {
                return CRO_SUMMARY_OVERFLOW;
            }
            case 4: {
                return "CR1LT";
            }
            case 5: {
                return "CR1GT";
            }
            case 6: {
                return "CR1EQ";
            }
            case 7: {
                return "CR1SO";
            }
            case 8: {
                return "CR2LT";
            }
            case 9: {
                return "CR2GT";
            }
            case 10: {
                return "CR2EQ";
            }
            case 11: {
                return "CR2SO";
            }
            case 12: {
                return "CR3LT";
            }
            case 13: {
                return "CR3GT";
            }
            case 14: {
                return "CR3EQ";
            }
            case 15: {
                return "CR3SO";
            }
            case 16: {
                return "CR4LT";
            }
            case 17: {
                return "CR4GT";
            }
            case 18: {
                return "CR4EQ";
            }
            case 19: {
                return "CR4SO";
            }
            case 20: {
                return "CR5LT";
            }
            case 21: {
                return "CR5GT";
            }
            case 22: {
                return "CR5EQ";
            }
            case 23: {
                return "CR5SO";
            }
            case 24: {
                return "CR6LT";
            }
            case 25: {
                return "CR6GT";
            }
            case 26: {
                return "CR6EQ";
            }
            case 27: {
                return "CR6SO";
            }
            case 28: {
                return "CR7LT";
            }
            case 29: {
                return "CR7GT";
            }
            case 30: {
                return "CR7EQ";
            }
            case 31: {
                return "CR7SO";
            }
        }
        return "";
    }

    public static String getCRM(int crm) {
        Long mask = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            mask = mask << 4;
            if ((crm >> 7 - i2 & 1) != 1) continue;
            mask = mask | 0xFL;
        }
        return mask.toString();
    }

    public static int getCRRegisterIndex(String register2) {
        Integer retval = 0;
        try {
            retval = Integer.decode(register2);
        }
        catch (NumberFormatException e2) {
            String registerNumber = register2.substring(2);
            retval = Integer.decode(registerNumber);
        }
        return retval;
    }

    public static String getRealRegisterName(String register2) {
        String name = "";
        if (register2.startsWith("%")) {
            name = register2;
        } else {
            String string2 = String.valueOf(register2);
            String string3 = name = string2.length() != 0 ? "%".concat(string2) : new String("%");
        }
        if (register2.equals("rtoc") || register2.equals("%rtoc")) {
            name = "%r2";
        } else if (register2.equals("sp") || register2.equals("%sp")) {
            name = "%r1";
        }
        return name;
    }

    public static int getRegisterIndex(String register2) {
        String registerNumber = Helpers.getRealRegisterName(register2).substring(2);
        return Integer.decode(registerNumber);
    }

    public static String getRotateMask(String MB, String ME) {
        Long mask = 0L;
        int mb = Integer.decode(MB);
        int me = Integer.decode(ME);
        if (mb == 0 && me == 31) {
            return String.valueOf(0xFFFFFFFFL);
        }
        int i2 = mb;
        while (i2 != (me + 1) % 32) {
            mask = mask | (mask >> 31 - i2 | 1L) << 31 - i2;
            i2 = (i2 + 1) % 32;
        }
        return mask.toString();
    }
}

