/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.ppc.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class CrandTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "crand");
        IOperandTreeNode targetCRBit = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode sourceCRBit1 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode sourceCRBit2 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        Long baseOffset = instruction.getAddress().toLong() * 256L;
        OperandSize bt2 = OperandSize.BYTE;
        Long l2 = baseOffset;
        Long l3 = baseOffset = Long.valueOf(baseOffset + 1L);
        instructions.add(ReilHelpers.createAnd(l2, bt2, Helpers.getCRBit(Integer.decode(sourceCRBit1.getValue())), bt2, Helpers.getCRBit(Integer.decode(sourceCRBit2.getValue())), bt2, Helpers.getCRBit(Integer.decode(targetCRBit.getValue()))));
    }
}

