/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class CmpGenerator {
    public static void generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic, String firstOperand, String secondOperand, String thirdOperand, boolean isLogical) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, mnemonic);
        String conditionRegister = firstOperand.toUpperCase();
        String realFirstOperand = secondOperand;
        String realSecondOperand = thirdOperand;
        String crTemp = environment.getNextVariableString();
        String firstToUnsigned = !isLogical ? environment.getNextVariableString() : null;
        String secondToUnsigned = !isLogical ? environment.getNextVariableString() : null;
        String firstUnsigned = !isLogical ? environment.getNextVariableString() : realFirstOperand;
        String secondUnsigned = !isLogical ? environment.getNextVariableString() : realSecondOperand;
        String logicalTmpQword = environment.getNextVariableString();
        String logicalTmp = environment.getNextVariableString();
        if (!isLogical) {
            instructions.add(ReilHelpers.createAdd(baseOffset++, OperandSize.DWORD, realFirstOperand, OperandSize.DWORD, "2147483648", OperandSize.QWORD, firstToUnsigned));
            instructions.add(ReilHelpers.createAdd(baseOffset++, OperandSize.DWORD, realSecondOperand, OperandSize.DWORD, "2147483648", OperandSize.QWORD, secondToUnsigned));
            instructions.add(ReilHelpers.createAnd(baseOffset++, OperandSize.QWORD, firstToUnsigned, OperandSize.DWORD, "4294967295", OperandSize.DWORD, firstUnsigned));
            instructions.add(ReilHelpers.createAnd(baseOffset++, OperandSize.QWORD, secondToUnsigned, OperandSize.DWORD, "4294967295", OperandSize.DWORD, secondUnsigned));
        }
        instructions.add(ReilHelpers.createSub(baseOffset++, OperandSize.DWORD, firstUnsigned, OperandSize.DWORD, secondUnsigned, OperandSize.QWORD, logicalTmpQword));
        instructions.add(ReilHelpers.createAnd(baseOffset++, OperandSize.QWORD, logicalTmpQword, OperandSize.DWORD, "8589934591", OperandSize.QWORD, logicalTmp));
        instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.QWORD, logicalTmp, OperandSize.BYTE, String.valueOf(conditionRegister).concat("EQ")));
        instructions.add(ReilHelpers.createBsh(baseOffset++, OperandSize.QWORD, logicalTmp, OperandSize.WORD, "-32", OperandSize.BYTE, String.valueOf(conditionRegister).concat("LT")));
        instructions.add(ReilHelpers.createOr(baseOffset++, OperandSize.BYTE, String.valueOf(conditionRegister).concat("EQ"), OperandSize.BYTE, String.valueOf(conditionRegister).concat("LT"), OperandSize.BYTE, crTemp));
        instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.BYTE, crTemp, OperandSize.BYTE, String.valueOf(conditionRegister).concat("GT")));
        instructions.add(ReilHelpers.createStr(baseOffset, OperandSize.BYTE, "XERSO", OperandSize.BYTE, String.valueOf(conditionRegister).concat("SO")));
    }
}

