/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.ppc.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class BranchGenerator {
    public static void generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic, String BIOperand, String addressOperand, boolean setLinkRegister, boolean isUnconditional, boolean ctrDecrement, boolean ctrZero, boolean crCheck, boolean crZero) throws InternalTranslationException {
        String[] meta;
        String[] stringArray;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, mnemonic);
        OperandSize qw = OperandSize.QWORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize bt2 = OperandSize.BYTE;
        String tmpCountRegister = ctrDecrement ? environment.getNextVariableString() : null;
        String branchCondition = environment.getNextVariableString();
        String conditionConditionRegister = environment.getNextVariableString();
        String conditionCountRegister = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        if (setLinkRegister) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "isCall";
            stringArray = stringArray2;
            stringArray2[1] = "true";
        } else {
            stringArray = meta = new String[]{};
        }
        if (setLinkRegister) {
            instructions.add(ReilHelpers.createStr(baseOffset++, OperandSize.DWORD, String.valueOf(instruction.getAddress().toLong() + 4L), OperandSize.DWORD, "lr"));
        }
        if (isUnconditional) {
            instructions.add(ReilHelpers.createJcc(baseOffset++, bt2, String.valueOf(1L), dw, addressOperand, meta));
        } else {
            if (ctrDecrement) {
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, "ctr", bt2, String.valueOf(1L), qw, tmpCountRegister));
                instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpCountRegister, dw, String.valueOf(0xFFFFFFFFL), dw, "ctr"));
            }
            if (ctrDecrement & !crCheck) {
                if (ctrZero) {
                    instructions.add(ReilHelpers.createBisz(baseOffset++, dw, "ctr", bt2, branchCondition));
                    instructions.add(ReilHelpers.createJcc(baseOffset++, bt2, branchCondition, dw, addressOperand, meta));
                } else {
                    instructions.add(ReilHelpers.createJcc(baseOffset++, dw, "ctr", dw, addressOperand, meta));
                }
            } else if (ctrDecrement & crCheck) {
                if (ctrZero) {
                    instructions.add(ReilHelpers.createBisz(baseOffset++, dw, "ctr", bt2, conditionCountRegister));
                } else {
                    instructions.add(ReilHelpers.createBisz(baseOffset++, dw, "ctr", bt2, tmpVar1));
                    instructions.add(ReilHelpers.createXor(baseOffset++, bt2, tmpVar1, bt2, String.valueOf(1L), bt2, conditionCountRegister));
                }
                if (crZero) {
                    instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, Helpers.getCRBit(Integer.valueOf(BIOperand)), bt2, conditionConditionRegister));
                } else {
                    instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, Helpers.getCRBit(Integer.valueOf(BIOperand)), bt2, tmpVar2));
                    instructions.add(ReilHelpers.createXor(baseOffset++, bt2, tmpVar2, bt2, String.valueOf(1L), bt2, conditionConditionRegister));
                }
                instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, conditionConditionRegister, bt2, conditionCountRegister, bt2, branchCondition));
                instructions.add(ReilHelpers.createJcc(baseOffset++, bt2, branchCondition, dw, addressOperand, meta));
            } else if (!ctrDecrement & crCheck) {
                if (crZero) {
                    instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, Helpers.getCRBit(Integer.valueOf(BIOperand)), bt2, branchCondition));
                    instructions.add(ReilHelpers.createJcc(baseOffset++, bt2, branchCondition, dw, addressOperand, meta));
                } else {
                    instructions.add(ReilHelpers.createJcc(baseOffset++, bt2, Helpers.getCRBit(Integer.valueOf(BIOperand)), dw, addressOperand, meta));
                }
            } else if (!ctrDecrement & !crCheck) {
                instructions.add(ReilHelpers.createJcc(baseOffset++, bt2, BIOperand, dw, addressOperand, meta));
            }
        }
    }
}

