/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class AndGenerator {
    public static void generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic, String firstOperand, String secondOperand, boolean setCr, boolean isNand, boolean withComplement) throws InternalTranslationException {
        String complementVar;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, mnemonic);
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String crTemp = setCr ? environment.getNextVariableString() : null;
        String nandVar = isNand ? environment.getNextVariableString() : null;
        String string2 = complementVar = withComplement ? environment.getNextVariableString() : null;
        if (isNand) {
            instructions.add(ReilHelpers.createAnd(baseOffset++, OperandSize.DWORD, firstOperand, OperandSize.DWORD, secondOperand, OperandSize.DWORD, nandVar));
            instructions.add(ReilHelpers.createXor(baseOffset++, OperandSize.DWORD, nandVar, OperandSize.DWORD, "4294967295", OperandSize.DWORD, targetRegister));
        } else if (withComplement) {
            instructions.add(ReilHelpers.createXor(baseOffset++, OperandSize.DWORD, secondOperand, OperandSize.DWORD, "4294967295", OperandSize.DWORD, complementVar));
            instructions.add(ReilHelpers.createAnd(baseOffset++, OperandSize.DWORD, firstOperand, OperandSize.DWORD, complementVar, OperandSize.DWORD, targetRegister));
        } else {
            instructions.add(ReilHelpers.createAnd(baseOffset++, OperandSize.DWORD, firstOperand, OperandSize.DWORD, secondOperand, OperandSize.QWORD, targetRegister));
        }
        if (setCr) {
            instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.BYTE, "CR0EQ"));
            instructions.add(ReilHelpers.createBsh(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.WORD, "-31", OperandSize.BYTE, "CR0LT"));
            instructions.add(ReilHelpers.createOr(baseOffset++, OperandSize.BYTE, "CR0EQ", OperandSize.BYTE, "CR0LT", OperandSize.BYTE, crTemp));
            instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.BYTE, crTemp, OperandSize.BYTE, "CR0GT"));
            instructions.add(ReilHelpers.createStr(baseOffset, OperandSize.BYTE, "XERSO", OperandSize.BYTE, "CR0SO"));
        }
    }
}

