/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.ppc.AddGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.math.BigInteger;
import java.util.List;

public class AddiTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "addi");
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode literalOperand1 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        long baseOffset = instruction.getAddress().toLong() * 256L;
        String tmpLiteralValue = environment.getNextVariableString();
        BigInteger literalValue = BigInteger.valueOf(Long.valueOf(literalOperand1.getValue()));
        if (literalValue.testBit(15)) {
            instructions.add(ReilHelpers.createStr(baseOffset++, OperandSize.DWORD, String.valueOf(literalValue.or(BigInteger.valueOf(0xFFFF0000L))), OperandSize.DWORD, tmpLiteralValue));
        } else {
            instructions.add(ReilHelpers.createStr(baseOffset++, OperandSize.DWORD, String.valueOf(literalValue), OperandSize.DWORD, tmpLiteralValue));
        }
        AddGenerator.generate(baseOffset, environment, instruction, instructions, "addi", registerOperand1.getValue(), tmpLiteralValue, false, false, false, false);
    }
}

