/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.OperandLoader;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.general.Triple;
import java.util.List;

public class SraTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "sra");
        Triple<IOperandTree, IOperandTree, IOperandTree> operands = OperandLoader.loadDuplicateFirst(instruction);
        String rd = operands.first().getRootNode().getChildren().get(0).getValue();
        String rt = operands.second().getRootNode().getChildren().get(0).getValue();
        String sa = operands.third().getRootNode().getChildren().get(0).getValue();
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        String tempOperand1 = environment.getNextVariableString();
        String tempOperand2 = environment.getNextVariableString();
        String tempOperand3 = environment.getNextVariableString();
        String tempOperand4 = environment.getNextVariableString();
        long l2 = offset++;
        String string2 = String.valueOf(sa);
        instructions.add(ReilHelpers.createBsh(l2, dw, String.valueOf(0x80000000L), dw, string2.length() != 0 ? "-".concat(string2) : new String("-"), dw, tempOperand1));
        long l3 = offset++;
        String string3 = String.valueOf(sa);
        instructions.add(ReilHelpers.createBsh(l3, dw, rt, dw, string3.length() != 0 ? "-".concat(string3) : new String("-"), dw, tempOperand2));
        instructions.add(ReilHelpers.createXor(offset++, dw, tempOperand1, dw, tempOperand2, dw, tempOperand3));
        instructions.add(ReilHelpers.createSub(offset++, dw, tempOperand3, dw, tempOperand1, qw, tempOperand4));
        instructions.add(ReilHelpers.createAnd(offset, qw, tempOperand4, dw, String.valueOf(0xFFFFFFFFL), dw, rd));
    }
}

