/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.OperandLoader;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.general.Triple;
import java.util.List;

public class SltuTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "sltu");
        Triple<IOperandTree, IOperandTree, IOperandTree> operands = OperandLoader.loadDuplicateFirst(instruction);
        String targetRegister = operands.first().getRootNode().getChildren().get(0).getValue();
        String sourceRegister1 = operands.second().getRootNode().getChildren().get(0).getValue();
        String sourceRegister2 = operands.third().getRootNode().getChildren().get(0).getValue();
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        String subtractedValue = environment.getNextVariableString();
        String maskedCarry = environment.getNextVariableString();
        instructions.add(ReilHelpers.createSub(offset++, dw, sourceRegister1, dw, sourceRegister2, qw, subtractedValue));
        instructions.add(ReilHelpers.createAnd(offset++, qw, subtractedValue, qw, String.valueOf(0x100000000L), qw, maskedCarry));
        instructions.add(ReilHelpers.createBisz(offset++, qw, maskedCarry, dw, targetRegister));
        instructions.add(ReilHelpers.createBisz(offset++, dw, targetRegister, dw, targetRegister));
    }
}

