/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.SignExtendGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class ScTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "sc");
        String sourceRegister = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        OperandSize dw = OperandSize.DWORD;
        String extendedValue = SignExtendGenerator.extendAndAdd(offset, environment, instruction.getOperands().get(1), instructions);
        offset = baseOffset + (long)instructions.size();
        String jumpCondition = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBisz(offset++, dw, "LL", dw, jumpCondition));
        String jmpGoal = String.format("%d.%d", instruction.getAddress().toLong(), instructions.size() + 2);
        instructions.add(ReilHelpers.createJcc(offset++, dw, jumpCondition, dw, jmpGoal, new String[0]));
        instructions.add(ReilHelpers.createStm(offset++, dw, sourceRegister, dw, extendedValue));
        instructions.add(ReilHelpers.createStr(offset, dw, "LL", dw, sourceRegister));
    }
}

