/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class MaddTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "madd");
        String sourceRegister1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String sourceRegister2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        String signedMultiplicationResult = environment.getNextVariableString();
        String hiShifted = environment.getNextVariableString();
        String hiAndLoConcatenated = environment.getNextVariableString();
        String temporaryResult = environment.getNextVariableString();
        String temporaryHigh = environment.getNextVariableString();
        Helpers.signedMul(offset, environment, instructions, dw, sourceRegister1, dw, sourceRegister2, qw, signedMultiplicationResult);
        offset = baseOffset + (long)instructions.size();
        instructions.add(ReilHelpers.createBsh(offset++, dw, "HI", dw, String.valueOf(32L), qw, hiShifted));
        instructions.add(ReilHelpers.createOr(offset++, qw, hiShifted, dw, "LO", qw, hiAndLoConcatenated));
        instructions.add(ReilHelpers.createAdd(offset++, qw, hiAndLoConcatenated, qw, signedMultiplicationResult, qw, temporaryResult));
        instructions.add(ReilHelpers.createAnd(offset++, qw, temporaryResult, dw, String.valueOf(0xFFFFFFFFL), dw, "LO"));
        instructions.add(ReilHelpers.createBsh(offset++, qw, temporaryResult, dw, String.valueOf(-32L), dw, temporaryHigh));
        instructions.add(ReilHelpers.createAnd(offset++, qw, temporaryHigh, dw, String.valueOf(0xFFFFFFFFL), dw, "HI"));
    }
}

