/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class JalrTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "jalr");
        List<? extends IOperandTree> operands = instruction.getOperands();
        long returnAddress = instruction.getAddress().toLong() + 4L;
        String rd = operands.size() == 1 ? "$ra" : operands.get(0).getRootNode().getChildren().get(0).getValue();
        String rs = operands.size() == 1 ? operands.get(0).getRootNode().getChildren().get(0).getValue() : operands.get(1).getRootNode().getChildren().get(0).getValue();
        OperandSize dw = OperandSize.DWORD;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        instructions.add(ReilHelpers.createStr(offset++, dw, String.valueOf(returnAddress), dw, rd));
        instructions.add(ReilHelpers.createJcc(offset++, dw, String.valueOf(1L), dw, rs, "isCall", "true"));
    }
}

