/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class DivTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "div");
        String sourceRegister1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String sourceRegister2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        OperandSize dw = OperandSize.DWORD;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        Pair<String, String> sourceRegister1Abs = Helpers.generateAbs(environment, offset, sourceRegister1, dw, instructions);
        String sourceRegister1Absolute = sourceRegister1Abs.second();
        offset = baseOffset + (long)instructions.size();
        Pair<String, String> sourceRegister2Abs = Helpers.generateAbs(environment, offset, sourceRegister2, dw, instructions);
        String sourceRegister2Absolute = sourceRegister2Abs.second();
        offset = baseOffset + (long)instructions.size();
        String divResult = environment.getNextVariableString();
        String modResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createDiv(offset++, dw, sourceRegister1Absolute, dw, sourceRegister2Absolute, dw, divResult));
        instructions.add(ReilHelpers.createMod(offset++, dw, sourceRegister1Absolute, dw, sourceRegister2Absolute, dw, modResult));
        String xoredSigns = environment.getNextVariableString();
        String divToggleMask = environment.getNextVariableString();
        String xoredDivResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createXor(offset++, dw, sourceRegister1Abs.first(), dw, sourceRegister2Abs.first(), dw, xoredSigns));
        instructions.add(ReilHelpers.createSub(offset++, dw, String.valueOf(0L), dw, xoredSigns, dw, divToggleMask));
        instructions.add(ReilHelpers.createXor(offset++, dw, divToggleMask, dw, divResult, dw, xoredDivResult));
        instructions.add(ReilHelpers.createAdd(offset++, dw, xoredDivResult, dw, xoredSigns, dw, "LO"));
        String modToggleMask = environment.getNextVariableString();
        String xoredModResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createSub(offset++, dw, String.valueOf(0L), dw, sourceRegister1Abs.first(), dw, modToggleMask));
        instructions.add(ReilHelpers.createXor(offset++, dw, modToggleMask, dw, modResult, dw, xoredModResult));
        instructions.add(ReilHelpers.createAdd(offset++, dw, xoredModResult, dw, sourceRegister1Abs.first(), dw, "HI"));
    }
}

