/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class DdivTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "ddiv");
        String sourceRegister1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String sourceRegister2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        OperandSize qw = OperandSize.QWORD;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        Pair<String, String> sourceRegister1Abs = Helpers.generateAbs(environment, offset, sourceRegister1, qw, instructions);
        String sourceRegister1Absolute = sourceRegister1Abs.second();
        offset = baseOffset + (long)instructions.size();
        Pair<String, String> sourceRegister2Abs = Helpers.generateAbs(environment, offset, sourceRegister2, qw, instructions);
        String sourceRegister2Absolute = sourceRegister2Abs.second();
        offset = baseOffset + (long)instructions.size();
        String divResult = environment.getNextVariableString();
        String modResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createDiv(offset++, qw, sourceRegister1Absolute, qw, sourceRegister2Absolute, qw, divResult));
        instructions.add(ReilHelpers.createMod(offset, qw, sourceRegister1Absolute, qw, sourceRegister2Absolute, qw, modResult));
        String xoredSigns = environment.getNextVariableString();
        String divToggleMask = environment.getNextVariableString();
        String xoredDivResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createXor(offset++, qw, sourceRegister1Abs.first(), qw, sourceRegister2Abs.first(), qw, xoredSigns));
        instructions.add(ReilHelpers.createSub(offset++, qw, String.valueOf(0L), qw, xoredSigns, qw, divToggleMask));
        instructions.add(ReilHelpers.createXor(offset++, qw, divToggleMask, qw, divResult, qw, xoredDivResult));
        instructions.add(ReilHelpers.createAdd(offset, qw, xoredDivResult, qw, xoredSigns, qw, "LO"));
        String modToggleMask = environment.getNextVariableString();
        String xoredModResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createSub(offset++, qw, String.valueOf(0L), qw, sourceRegister1Abs.first(), qw, modToggleMask));
        instructions.add(ReilHelpers.createXor(offset++, qw, modToggleMask, qw, modResult, qw, xoredModResult));
        instructions.add(ReilHelpers.createAdd(offset, qw, xoredModResult, qw, sourceRegister1Abs.first(), qw, "HI"));
    }
}

