/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.SignExtendGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class DadduTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "daddu");
        String targetRegister = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String sourceRegister1 = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        String sourceRegister2 = instruction.getOperands().get(2).getRootNode().getChildren().get(0).getValue();
        OperandSize qw = OperandSize.QWORD;
        OperandSize ow = OperandSize.OWORD;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        String temporaryResult = environment.getNextVariableString();
        String sourceImmediateSignExtended = SignExtendGenerator.extend16BitTo64(offset, environment, sourceRegister2, instructions);
        instructions.add(ReilHelpers.createAdd(offset++, qw, sourceRegister1, qw, sourceImmediateSignExtended, ow, temporaryResult));
        instructions.add(ReilHelpers.createAnd(offset, ow, temporaryResult, qw, String.valueOf(-1L), qw, targetRegister));
    }
}

