/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class BgezallTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "bgezall");
        List<? extends IOperandTree> operands = instruction.getOperands();
        String rs = operands.get(0).getRootNode().getChildren().get(0).getValue();
        IOperandTreeNode target = operands.get(1).getRootNode().getChildren().get(0);
        OperandSize dw = OperandSize.DWORD;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        String rsOnesComplement = environment.getNextVariableString();
        String jumpCondition = environment.getNextVariableString();
        instructions.add(ReilHelpers.createXor(offset++, dw, rs, dw, String.valueOf(0xFFFFFFFFL), dw, rsOnesComplement));
        instructions.add(ReilHelpers.createBsh(offset++, dw, rsOnesComplement, dw, String.valueOf(-31L), dw, jumpCondition));
        Helpers.generateDelayBranchLikely(instructions, offset, dw, jumpCondition, dw, target);
    }
}

