/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.SignExtendGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class AddiTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "addi");
        String targetRegister = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String sourceRegister = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        String sourceImmediate = instruction.getOperands().get(2).getRootNode().getChildren().get(0).getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        String temporaryResult = environment.getNextVariableString();
        String bit31 = environment.getNextVariableString();
        String bit32 = environment.getNextVariableString();
        String jumpCondition = environment.getNextVariableString();
        String xoredBits = environment.getNextVariableString();
        String sourceImmediateSignExtended = SignExtendGenerator.extend16BitTo32(offset, environment, sourceImmediate, instructions);
        instructions.add(ReilHelpers.createAdd(offset++, dw, sourceRegister, dw, sourceImmediateSignExtended, qw, temporaryResult));
        instructions.add(ReilHelpers.createBsh(offset++, qw, temporaryResult, dw, String.valueOf(-31L), bt2, bit31));
        instructions.add(ReilHelpers.createBsh(offset++, qw, temporaryResult, dw, String.valueOf(-32L), bt2, bit32));
        instructions.add(ReilHelpers.createXor(offset++, bt2, bit31, bt2, bit32, bt2, xoredBits));
        instructions.add(ReilHelpers.createBisz(offset++, bt2, xoredBits, bt2, jumpCondition));
        String jmpGoal = String.format("%d.%d", instruction.getAddress().toLong(), instructions.size() + 2);
        instructions.add(ReilHelpers.createJcc(offset++, bt2, jumpCondition, dw, jmpGoal, new String[0]));
        instructions.add(ReilHelpers.createAnd(offset++, qw, temporaryResult, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister));
        instructions.add(ReilHelpers.createNop(offset));
    }
}

