/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.ITranslationExtension;
import com.google.security.zynamics.reil.translators.ITranslator;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.arm.ARMAdcTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMAddTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMAdrTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMAdrlTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMAlignTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMAndTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMBicTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMBkptTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMBlTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMBlxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMBxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMBxjTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMCdpTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMClzTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMCmnTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMCmpTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMCpsTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMCpyTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMDcTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMEorTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMLdcTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMLdmTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMLdrTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMLdrbTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMLdrbtTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMLdrdTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMLdrexTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMLdrhTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMLdrhtTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMLdrsbTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMLdrshTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMLdrtTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMMcrTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMMcrrTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMMlaTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMMovTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMMrcTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMMrrcTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMMrsTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMMsrTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMMulTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMMvnTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMNopTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMOrnTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMOrrTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMPkhbtTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMPkhtbTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMPldTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMQadd16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMQadd8Translator;
import com.google.security.zynamics.reil.translators.arm.ARMQaddTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMQaddsubxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMQdaddTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMQdsubTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMQsub16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMQsub8Translator;
import com.google.security.zynamics.reil.translators.arm.ARMQsubTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMQsubaddxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMRev16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMRevTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMRevshTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMRfeTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMRrxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMRsbTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMRscTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSBFXTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSadd16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMSadd8Translator;
import com.google.security.zynamics.reil.translators.arm.ARMSaddsubxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSbcTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSdivTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSelTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSetendTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMShadd16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMShadd8Translator;
import com.google.security.zynamics.reil.translators.arm.ARMShaddsubxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMShsub16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMShsub8Translator;
import com.google.security.zynamics.reil.translators.arm.ARMShsubaddxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmlaXYTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmladTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmlalTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmlalXYTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmlaldTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmlawYTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmlsdTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmlsldTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmmlaTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmmlsTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmmulTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmuadTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmulXYTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmullTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmulwYTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSmusdTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSrsTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSsat16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMSsatTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSsub16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMSsub8Translator;
import com.google.security.zynamics.reil.translators.arm.ARMSsubaddxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMStcTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMStmTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMStrTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMStrbTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMStrbtTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMStrdTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMStrexTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMStrhTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMStrtTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSubTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSwiTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSwpTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSwpbTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSxtab16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMSxtabTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSxtahTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSxtb16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMSxtbTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMSxthTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMTeqTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMTstTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUBFXTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUadd16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUadd8Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUaddsubxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUdivTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUhadd16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUhadd8Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUhaddsubxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUhsub16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUhsub8Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUhsubaddxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUmaalTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUmlalTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUmullTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUqadd16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUqadd8Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUqaddsubxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUqsub16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUqsub8Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUqsubaddxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUsad8Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUsada8Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUsat16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUsatTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUsub16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUsub8Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUsubaddxTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUxtab16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUxtabTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUxtahTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUxtb16Translator;
import com.google.security.zynamics.reil.translators.arm.ARMUxtbTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMUxthTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMB2BFCTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMB2BFITranslator;
import com.google.security.zynamics.reil.translators.arm.THUMB2CbnzTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMB2CbzTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMB2ItTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMB2LDRDTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMB2MlsTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMB2MovtTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMB2RBITTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMB2STRDTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMB2TbbTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMB2TbhTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBAdcTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBAddTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBAndTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBAsrTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBBTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBBicTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBBkptTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBBlTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBBxTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBCmnTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBCmpTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBCpsTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBCpyTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBEorTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBLdmiaTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBLdrTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBLdrbTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBLdrhTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBLdrsbTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBLdrshTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBLslTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBLsrTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBMovTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBMulTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBMvnTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBNegTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBNopTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBOrrTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBPopTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBPushTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBRev16Translator;
import com.google.security.zynamics.reil.translators.arm.THUMBRevTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBRevshTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBRorTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBSbcTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBSetendTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBStmiaTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBStrTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBStrbTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBStrhTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBSubTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBSwiTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBSxtbTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBSxthTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBTstTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBUxtbTranslator;
import com.google.security.zynamics.reil.translators.arm.THUMBUxthTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TranslatorARM<InstructionType extends IInstruction>
implements ITranslator<InstructionType> {
    private static HashMap<String, IInstructionTranslator> translators = new HashMap();
    private static final String matchLDR = "LDR";
    private static final String matchSTR = "STR";

    @Override
    public List<ReilInstruction> translate(ITranslationEnvironment environment, InstructionType instruction, List<ITranslationExtension<InstructionType>> extensions) throws InternalTranslationException {
        String string2;
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instruction, "Error: Argument instruction can't be null");
        String mnemonic = instruction.getMnemonic();
        long instLength = instruction.getLength();
        if (instLength >= 4L) {
            string2 = mnemonic;
        } else {
            String string3 = String.valueOf(mnemonic);
            string2 = string3.length() != 0 ? "THUMB".concat(string3) : new String("THUMB");
        }
        String normalizedMnemonic = string2;
        IInstructionTranslator translator = translators.get(normalizedMnemonic);
        if (translators.containsKey(normalizedMnemonic)) {
            ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
            translator.translate(environment, (IInstruction)instruction, (List<ReilInstruction>)instructions);
            return instructions;
        }
        if (mnemonic == null) {
            return new ArrayList<ReilInstruction>();
        }
        return Lists.newArrayList(ReilHelpers.createUnknown(ReilHelpers.toReilAddress(instruction.getAddress()).toLong()));
    }

    static {
        try {
            translators.put("NOP", new ARMNopTranslator());
            String[] conditions = new String[]{"", "EQ", "NE", "CS", "HS", "CC", "LO", "MI", "PL", "VS", "VC", "HI", "LS", "GE", "LT", "GT", "LE", "AL", "NV"};
            String[] multiRegisterInstructions = new String[]{"DA", "DB", "IA", "IB", "EA", "FA", "FD", "ED"};
            for (String condition : conditions) {
                String string2 = String.valueOf(condition);
                translators.put(string2.length() != 0 ? "ADC".concat(string2) : new String("ADC"), new ARMAdcTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("ADC").append(condition).append("S").toString(), new ARMAdcTranslator());
                String string3 = String.valueOf(condition);
                translators.put(string3.length() != 0 ? "ADD".concat(string3) : new String("ADD"), new ARMAddTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("ADD").append(condition).append("S").toString(), new ARMAddTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("ADDW").append(condition).append("S").toString(), new ARMAddTranslator());
                String string4 = String.valueOf(condition);
                translators.put(string4.length() != 0 ? "ADDW".concat(string4) : new String("ADDW"), new ARMAddTranslator());
                String string5 = String.valueOf(condition);
                translators.put(string5.length() != 0 ? "ADDS".concat(string5) : new String("ADDS"), new ARMAddTranslator());
                String string6 = String.valueOf(condition);
                translators.put(string6.length() != 0 ? "ADRL".concat(string6) : new String("ADRL"), new ARMAdrlTranslator());
                String string7 = String.valueOf(condition);
                translators.put(string7.length() != 0 ? "ADR".concat(string7) : new String("ADR"), new ARMAdrTranslator());
                String string8 = String.valueOf(condition);
                translators.put(string8.length() != 0 ? "ALIGN".concat(string8) : new String("ALIGN"), new ARMAlignTranslator());
                String string9 = String.valueOf(condition);
                translators.put(string9.length() != 0 ? "AND".concat(string9) : new String("AND"), new ARMAndTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("AND").append(condition).append("S").toString(), new ARMAndTranslator());
                String string10 = String.valueOf(condition);
                translators.put(string10.length() != 0 ? "BIC".concat(string10) : new String("BIC"), new ARMBicTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("BIC").append(condition).append("S").toString(), new ARMBicTranslator());
                translators.put("BKPT", new ARMBkptTranslator());
                String string11 = String.valueOf(condition);
                translators.put(string11.length() != 0 ? "BL".concat(string11) : new String("BL"), new ARMBlTranslator());
                String string12 = String.valueOf(condition);
                translators.put(string12.length() != 0 ? "B".concat(string12) : new String("B"), new ARMBlTranslator());
                String string13 = String.valueOf(condition);
                translators.put(string13.length() != 0 ? "BLX".concat(string13) : new String("BLX"), new ARMBlxTranslator());
                String string14 = String.valueOf(condition);
                translators.put(string14.length() != 0 ? "BXJ".concat(string14) : new String("BXJ"), new ARMBxjTranslator());
                String string15 = String.valueOf(condition);
                translators.put(string15.length() != 0 ? "BX".concat(string15) : new String("BX"), new ARMBxTranslator());
                String string16 = String.valueOf(condition);
                translators.put(string16.length() != 0 ? "CDP".concat(string16) : new String("CDP"), new ARMCdpTranslator());
                String string17 = String.valueOf(condition);
                translators.put(string17.length() != 0 ? "CLZ".concat(string17) : new String("CLZ"), new ARMClzTranslator());
                String string18 = String.valueOf(condition);
                translators.put(string18.length() != 0 ? "CMN".concat(string18) : new String("CMN"), new ARMCmnTranslator());
                String string19 = String.valueOf(condition);
                translators.put(string19.length() != 0 ? "CMP".concat(string19) : new String("CMP"), new ARMCmpTranslator());
                String string20 = String.valueOf(condition);
                translators.put(string20.length() != 0 ? "CPS".concat(string20) : new String("CPS"), new ARMCpsTranslator());
                String string21 = String.valueOf(condition);
                translators.put(string21.length() != 0 ? "CPY".concat(string21) : new String("CPY"), new ARMCpyTranslator());
                String string22 = String.valueOf(condition);
                translators.put(string22.length() != 0 ? "DCB".concat(string22) : new String("DCB"), new ARMDcTranslator());
                String string23 = String.valueOf(condition);
                translators.put(string23.length() != 0 ? "DCW".concat(string23) : new String("DCW"), new ARMDcTranslator());
                String string24 = String.valueOf(condition);
                translators.put(string24.length() != 0 ? "DCD".concat(string24) : new String("DCD"), new ARMDcTranslator());
                String string25 = String.valueOf(condition);
                translators.put(string25.length() != 0 ? "DCS".concat(string25) : new String("DCS"), new ARMDcTranslator());
                String string26 = String.valueOf(condition);
                translators.put(string26.length() != 0 ? "EOR".concat(string26) : new String("EOR"), new ARMEorTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("EOR").append(condition).append("S").toString(), new ARMEorTranslator());
                String string27 = String.valueOf(condition);
                translators.put(string27.length() != 0 ? "EQUB".concat(string27) : new String("EQUB"), new ARMEorTranslator());
                String string28 = String.valueOf(condition);
                translators.put(string28.length() != 0 ? "EQUW".concat(string28) : new String("EQUW"), new ARMEorTranslator());
                String string29 = String.valueOf(condition);
                translators.put(string29.length() != 0 ? "EQUD".concat(string29) : new String("EQUD"), new ARMEorTranslator());
                String string30 = String.valueOf(condition);
                translators.put(string30.length() != 0 ? "EQUS".concat(string30) : new String("EQUS"), new ARMEorTranslator());
                String string31 = String.valueOf(condition);
                translators.put(string31.length() != 0 ? "LDC".concat(string31) : new String("LDC"), new ARMLdcTranslator());
                for (String multiRegisterInstruction : multiRegisterInstructions) {
                    translators.put(new StringBuilder(3 + String.valueOf(condition).length() + String.valueOf(multiRegisterInstruction).length()).append("LDM").append(condition).append(multiRegisterInstruction).toString(), new ARMLdmTranslator());
                }
                String string32 = String.valueOf(matchLDR);
                translators.put(new StringBuilder(1 + String.valueOf(string32).length() + String.valueOf(condition).length()).append(string32).append(condition).append("B").toString(), new ARMLdrbTranslator());
                String string33 = String.valueOf(matchLDR);
                translators.put(new StringBuilder(2 + String.valueOf(string33).length() + String.valueOf(condition).length()).append(string33).append(condition).append("BT").toString(), new ARMLdrbtTranslator());
                String string34 = String.valueOf(matchLDR);
                translators.put(new StringBuilder(1 + String.valueOf(string34).length() + String.valueOf(condition).length()).append(string34).append(condition).append("D").toString(), new ARMLdrdTranslator());
                String string35 = String.valueOf(condition);
                translators.put(string35.length() != 0 ? "LDREX".concat(string35) : new String("LDREX"), new ARMLdrexTranslator());
                String string36 = String.valueOf(matchLDR);
                translators.put(new StringBuilder(1 + String.valueOf(string36).length() + String.valueOf(condition).length()).append(string36).append(condition).append("H").toString(), new ARMLdrhTranslator());
                String string37 = String.valueOf(matchLDR);
                translators.put(new StringBuilder(2 + String.valueOf(string37).length() + String.valueOf(condition).length()).append(string37).append(condition).append("SB").toString(), new ARMLdrsbTranslator());
                String string38 = String.valueOf(matchLDR);
                translators.put(new StringBuilder(2 + String.valueOf(string38).length() + String.valueOf(condition).length()).append(string38).append(condition).append("SH").toString(), new ARMLdrshTranslator());
                String string39 = String.valueOf(matchLDR);
                String string40 = String.valueOf(condition);
                translators.put(string40.length() != 0 ? string39.concat(string40) : new String(string39), new ARMLdrTranslator());
                String string41 = String.valueOf(matchLDR);
                translators.put(new StringBuilder(1 + String.valueOf(string41).length() + String.valueOf(condition).length()).append(string41).append(condition).append("T").toString(), new ARMLdrtTranslator());
                String string42 = String.valueOf(condition);
                translators.put(string42.length() != 0 ? "MCRR".concat(string42) : new String("MCRR"), new ARMMcrrTranslator());
                String string43 = String.valueOf(condition);
                translators.put(string43.length() != 0 ? "MCR".concat(string43) : new String("MCR"), new ARMMcrTranslator());
                String string44 = String.valueOf(condition);
                translators.put(string44.length() != 0 ? "MLA".concat(string44) : new String("MLA"), new ARMMlaTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("MLA").append(condition).append("S").toString(), new ARMMlaTranslator());
                String string45 = String.valueOf(condition);
                translators.put(string45.length() != 0 ? "MOV".concat(string45) : new String("MOV"), new ARMMovTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("MOV").append(condition).append("S").toString(), new ARMMovTranslator());
                String string46 = String.valueOf(condition);
                translators.put(string46.length() != 0 ? "MRC".concat(string46) : new String("MRC"), new ARMMrcTranslator());
                String string47 = String.valueOf(condition);
                translators.put(string47.length() != 0 ? "MRRC".concat(string47) : new String("MRRC"), new ARMMrrcTranslator());
                String string48 = String.valueOf(condition);
                translators.put(string48.length() != 0 ? "MRS".concat(string48) : new String("MRS"), new ARMMrsTranslator());
                String string49 = String.valueOf(condition);
                translators.put(string49.length() != 0 ? "MSR".concat(string49) : new String("MSR"), new ARMMsrTranslator());
                String string50 = String.valueOf(condition);
                translators.put(string50.length() != 0 ? "MUL".concat(string50) : new String("MUL"), new ARMMulTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("MUL").append(condition).append("S").toString(), new ARMMulTranslator());
                String string51 = String.valueOf(condition);
                translators.put(string51.length() != 0 ? "MVN".concat(string51) : new String("MVN"), new ARMMvnTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("MVN").append(condition).append("S").toString(), new ARMMvnTranslator());
                String string52 = String.valueOf(condition);
                translators.put(string52.length() != 0 ? "ORR".concat(string52) : new String("ORR"), new ARMOrrTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("ORR").append(condition).append("S").toString(), new ARMOrrTranslator());
                String string53 = String.valueOf(condition);
                translators.put(string53.length() != 0 ? "PKHBT".concat(string53) : new String("PKHBT"), new ARMPkhbtTranslator());
                String string54 = String.valueOf(condition);
                translators.put(string54.length() != 0 ? "PKHTB".concat(string54) : new String("PKHTB"), new ARMPkhtbTranslator());
                String string55 = String.valueOf(condition);
                translators.put(string55.length() != 0 ? "PLD".concat(string55) : new String("PLD"), new ARMPldTranslator());
                String string56 = String.valueOf(condition);
                translators.put(string56.length() != 0 ? "QADD16".concat(string56) : new String("QADD16"), new ARMQadd16Translator());
                String string57 = String.valueOf(condition);
                translators.put(string57.length() != 0 ? "QADD8".concat(string57) : new String("QADD8"), new ARMQadd8Translator());
                String string58 = String.valueOf(condition);
                translators.put(string58.length() != 0 ? "QADDSUBX".concat(string58) : new String("QADDSUBX"), new ARMQaddsubxTranslator());
                String string59 = String.valueOf(condition);
                translators.put(string59.length() != 0 ? "QASX".concat(string59) : new String("QASX"), new ARMQaddsubxTranslator());
                String string60 = String.valueOf(condition);
                translators.put(string60.length() != 0 ? "QADD".concat(string60) : new String("QADD"), new ARMQaddTranslator());
                String string61 = String.valueOf(condition);
                translators.put(string61.length() != 0 ? "QDADD".concat(string61) : new String("QDADD"), new ARMQdaddTranslator());
                String string62 = String.valueOf(condition);
                translators.put(string62.length() != 0 ? "QDSUB".concat(string62) : new String("QDSUB"), new ARMQdsubTranslator());
                String string63 = String.valueOf(condition);
                translators.put(string63.length() != 0 ? "QSUB16".concat(string63) : new String("QSUB16"), new ARMQsub16Translator());
                String string64 = String.valueOf(condition);
                translators.put(string64.length() != 0 ? "QSUb8".concat(string64) : new String("QSUb8"), new ARMQsub8Translator());
                String string65 = String.valueOf(condition);
                translators.put(string65.length() != 0 ? "QSUBADDX".concat(string65) : new String("QSUBADDX"), new ARMQsubaddxTranslator());
                String string66 = String.valueOf(condition);
                translators.put(string66.length() != 0 ? "QSAX".concat(string66) : new String("QSAX"), new ARMQsubaddxTranslator());
                String string67 = String.valueOf(condition);
                translators.put(string67.length() != 0 ? "QSUB".concat(string67) : new String("QSUB"), new ARMQsubTranslator());
                String string68 = String.valueOf(condition);
                translators.put(string68.length() != 0 ? "REV16".concat(string68) : new String("REV16"), new ARMRev16Translator());
                String string69 = String.valueOf(condition);
                translators.put(string69.length() != 0 ? "REVSH".concat(string69) : new String("REVSH"), new ARMRevshTranslator());
                String string70 = String.valueOf(condition);
                translators.put(string70.length() != 0 ? "REV".concat(string70) : new String("REV"), new ARMRevTranslator());
                String string71 = String.valueOf(condition);
                translators.put(string71.length() != 0 ? "RFE".concat(string71) : new String("RFE"), new ARMRfeTranslator());
                String string72 = String.valueOf(condition);
                translators.put(string72.length() != 0 ? "RSB".concat(string72) : new String("RSB"), new ARMRsbTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("RSB").append(condition).append("S").toString(), new ARMRsbTranslator());
                String string73 = String.valueOf(condition);
                translators.put(string73.length() != 0 ? "RSC".concat(string73) : new String("RSC"), new ARMRscTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("RSC").append(condition).append("S").toString(), new ARMRscTranslator());
                String string74 = String.valueOf(condition);
                translators.put(string74.length() != 0 ? "SADD16".concat(string74) : new String("SADD16"), new ARMSadd16Translator());
                String string75 = String.valueOf(condition);
                translators.put(string75.length() != 0 ? "SADD8".concat(string75) : new String("SADD8"), new ARMSadd8Translator());
                String string76 = String.valueOf(condition);
                translators.put(string76.length() != 0 ? "SADDSUBX".concat(string76) : new String("SADDSUBX"), new ARMSaddsubxTranslator());
                String string77 = String.valueOf(condition);
                translators.put(string77.length() != 0 ? "SASX".concat(string77) : new String("SASX"), new ARMSaddsubxTranslator());
                String string78 = String.valueOf(condition);
                translators.put(string78.length() != 0 ? "SBC".concat(string78) : new String("SBC"), new ARMSbcTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("SBC").append(condition).append("S").toString(), new ARMSbcTranslator());
                String string79 = String.valueOf(condition);
                translators.put(string79.length() != 0 ? "SEL".concat(string79) : new String("SEL"), new ARMSelTranslator());
                String string80 = String.valueOf(condition);
                translators.put(string80.length() != 0 ? "SETEND".concat(string80) : new String("SETEND"), new ARMSetendTranslator());
                String string81 = String.valueOf(condition);
                translators.put(string81.length() != 0 ? "SHADD16".concat(string81) : new String("SHADD16"), new ARMShadd16Translator());
                String string82 = String.valueOf(condition);
                translators.put(string82.length() != 0 ? "SHADD8".concat(string82) : new String("SHADD8"), new ARMShadd8Translator());
                String string83 = String.valueOf(condition);
                translators.put(string83.length() != 0 ? "SHADDSUBX".concat(string83) : new String("SHADDSUBX"), new ARMShaddsubxTranslator());
                String string84 = String.valueOf(condition);
                translators.put(string84.length() != 0 ? "SHASX".concat(string84) : new String("SHASX"), new ARMShaddsubxTranslator());
                String string85 = String.valueOf(condition);
                translators.put(string85.length() != 0 ? "SHSUB16".concat(string85) : new String("SHSUB16"), new ARMShsub16Translator());
                String string86 = String.valueOf(condition);
                translators.put(string86.length() != 0 ? "SHSUB8".concat(string86) : new String("SHSUB8"), new ARMShsub8Translator());
                String string87 = String.valueOf(condition);
                translators.put(string87.length() != 0 ? "SHSUBADDX".concat(string87) : new String("SHSUBADDX"), new ARMShsubaddxTranslator());
                String string88 = String.valueOf(condition);
                translators.put(string88.length() != 0 ? "SHSAX".concat(string88) : new String("SHSAX"), new ARMShsubaddxTranslator());
                String string89 = String.valueOf(condition);
                translators.put(string89.length() != 0 ? "SMLAD".concat(string89) : new String("SMLAD"), new ARMSmladTranslator());
                String string90 = String.valueOf(condition);
                translators.put(string90.length() != 0 ? "SMLALD".concat(string90) : new String("SMLALD"), new ARMSmlaldTranslator());
                String string91 = String.valueOf(condition);
                translators.put(string91.length() != 0 ? "SMLAL".concat(string91) : new String("SMLAL"), new ARMSmlalTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("SMLAL").append(condition).append("S").toString(), new ARMSmlalTranslator());
                String string92 = String.valueOf(condition);
                translators.put(string92.length() != 0 ? "SMLALXY".concat(string92) : new String("SMLALXY"), new ARMSmlalXYTranslator());
                String string93 = String.valueOf(condition);
                translators.put(string93.length() != 0 ? "SMLAWY".concat(string93) : new String("SMLAWY"), new ARMSmlawYTranslator());
                String string94 = String.valueOf(condition);
                translators.put(string94.length() != 0 ? "SMLAXY".concat(string94) : new String("SMLAXY"), new ARMSmlaXYTranslator());
                String string95 = String.valueOf(condition);
                translators.put(string95.length() != 0 ? "SMLSD".concat(string95) : new String("SMLSD"), new ARMSmlsdTranslator());
                String string96 = String.valueOf(condition);
                translators.put(string96.length() != 0 ? "SMLSDX".concat(string96) : new String("SMLSDX"), new ARMSmlsdTranslator());
                String string97 = String.valueOf(condition);
                translators.put(string97.length() != 0 ? "SMLSLD".concat(string97) : new String("SMLSLD"), new ARMSmlsldTranslator());
                String string98 = String.valueOf(condition);
                translators.put(string98.length() != 0 ? "SMLSLDX".concat(string98) : new String("SMLSLDX"), new ARMSmlsldTranslator());
                String string99 = String.valueOf(condition);
                translators.put(string99.length() != 0 ? "SMMLA".concat(string99) : new String("SMMLA"), new ARMSmmlaTranslator());
                String string100 = String.valueOf(condition);
                translators.put(string100.length() != 0 ? "SMMLAR".concat(string100) : new String("SMMLAR"), new ARMSmmlaTranslator());
                String string101 = String.valueOf(condition);
                translators.put(string101.length() != 0 ? "SMMLS".concat(string101) : new String("SMMLS"), new ARMSmmlsTranslator());
                String string102 = String.valueOf(condition);
                translators.put(string102.length() != 0 ? "SMMLSR".concat(string102) : new String("SMMLSR"), new ARMSmmlsTranslator());
                String string103 = String.valueOf(condition);
                translators.put(string103.length() != 0 ? "SMMUL".concat(string103) : new String("SMMUL"), new ARMSmmulTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("SMMUL").append(condition).append(".W").toString(), new ARMSmmulTranslator());
                String string104 = String.valueOf(condition);
                translators.put(string104.length() != 0 ? "SMMULR".concat(string104) : new String("SMMULR"), new ARMSmmulTranslator());
                translators.put(new StringBuilder(8 + String.valueOf(condition).length()).append("SMMULR").append(condition).append(".W").toString(), new ARMSmmulTranslator());
                String string105 = String.valueOf(condition);
                translators.put(string105.length() != 0 ? "SMUAD".concat(string105) : new String("SMUAD"), new ARMSmuadTranslator());
                String string106 = String.valueOf(condition);
                translators.put(string106.length() != 0 ? "SMUADX".concat(string106) : new String("SMUADX"), new ARMSmuadTranslator());
                String string107 = String.valueOf(condition);
                translators.put(string107.length() != 0 ? "SMULL".concat(string107) : new String("SMULL"), new ARMSmullTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("SMULL").append(condition).append("S").toString(), new ARMSmullTranslator());
                String string108 = String.valueOf(condition);
                translators.put(string108.length() != 0 ? "SMULWY".concat(string108) : new String("SMULWY"), new ARMSmulwYTranslator());
                String string109 = String.valueOf(condition);
                translators.put(string109.length() != 0 ? "SMULXY".concat(string109) : new String("SMULXY"), new ARMSmulXYTranslator());
                String string110 = String.valueOf(condition);
                translators.put(string110.length() != 0 ? "SMUSD".concat(string110) : new String("SMUSD"), new ARMSmusdTranslator());
                String string111 = String.valueOf(condition);
                translators.put(string111.length() != 0 ? "SMUSDX".concat(string111) : new String("SMUSDX"), new ARMSmusdTranslator());
                String string112 = String.valueOf(condition);
                translators.put(string112.length() != 0 ? "SRS".concat(string112) : new String("SRS"), new ARMSrsTranslator());
                String string113 = String.valueOf(condition);
                translators.put(string113.length() != 0 ? "SSAT16".concat(string113) : new String("SSAT16"), new ARMSsat16Translator());
                String string114 = String.valueOf(condition);
                translators.put(string114.length() != 0 ? "SSAT".concat(string114) : new String("SSAT"), new ARMSsatTranslator());
                String string115 = String.valueOf(condition);
                translators.put(string115.length() != 0 ? "SSUB16".concat(string115) : new String("SSUB16"), new ARMSsub16Translator());
                String string116 = String.valueOf(condition);
                translators.put(string116.length() != 0 ? "SSUB8".concat(string116) : new String("SSUB8"), new ARMSsub8Translator());
                String string117 = String.valueOf(condition);
                translators.put(string117.length() != 0 ? "SSUBADDX".concat(string117) : new String("SSUBADDX"), new ARMSsubaddxTranslator());
                String string118 = String.valueOf(condition);
                translators.put(string118.length() != 0 ? "SSAX".concat(string118) : new String("SSAX"), new ARMSsubaddxTranslator());
                String string119 = String.valueOf(condition);
                translators.put(string119.length() != 0 ? "STC".concat(string119) : new String("STC"), new ARMStcTranslator());
                for (String multiRegisterInstruction : multiRegisterInstructions) {
                    translators.put(new StringBuilder(3 + String.valueOf(condition).length() + String.valueOf(multiRegisterInstruction).length()).append("STM").append(condition).append(multiRegisterInstruction).toString(), new ARMStmTranslator());
                }
                String string120 = String.valueOf(matchSTR);
                translators.put(new StringBuilder(1 + String.valueOf(string120).length() + String.valueOf(condition).length()).append(string120).append(condition).append("B").toString(), new ARMStrbTranslator());
                String string121 = String.valueOf(matchSTR);
                translators.put(new StringBuilder(2 + String.valueOf(string121).length() + String.valueOf(condition).length()).append(string121).append(condition).append("BT").toString(), new ARMStrbtTranslator());
                String string122 = String.valueOf(matchSTR);
                translators.put(new StringBuilder(1 + String.valueOf(string122).length() + String.valueOf(condition).length()).append(string122).append(condition).append("D").toString(), new ARMStrdTranslator());
                String string123 = String.valueOf(condition);
                translators.put(string123.length() != 0 ? "STREX".concat(string123) : new String("STREX"), new ARMStrexTranslator());
                String string124 = String.valueOf(matchSTR);
                translators.put(new StringBuilder(1 + String.valueOf(string124).length() + String.valueOf(condition).length()).append(string124).append(condition).append("H").toString(), new ARMStrhTranslator());
                String string125 = String.valueOf(matchSTR);
                String string126 = String.valueOf(condition);
                translators.put(string126.length() != 0 ? string125.concat(string126) : new String(string125), new ARMStrTranslator());
                String string127 = String.valueOf(matchSTR);
                translators.put(new StringBuilder(1 + String.valueOf(string127).length() + String.valueOf(condition).length()).append(string127).append(condition).append("T").toString(), new ARMStrtTranslator());
                String string128 = String.valueOf(condition);
                translators.put(string128.length() != 0 ? "SUB".concat(string128) : new String("SUB"), new ARMSubTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("SUB").append(condition).append("S").toString(), new ARMSubTranslator());
                String string129 = String.valueOf(condition);
                translators.put(string129.length() != 0 ? "SWI".concat(string129) : new String("SWI"), new ARMSwiTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("SWP").append(condition).append("B").toString(), new ARMSwpbTranslator());
                String string130 = String.valueOf(condition);
                translators.put(string130.length() != 0 ? "SWP".concat(string130) : new String("SWP"), new ARMSwpTranslator());
                String string131 = String.valueOf(condition);
                translators.put(string131.length() != 0 ? "SXTAB16".concat(string131) : new String("SXTAB16"), new ARMSxtab16Translator());
                String string132 = String.valueOf(condition);
                translators.put(string132.length() != 0 ? "SXTAB".concat(string132) : new String("SXTAB"), new ARMSxtabTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("SXTAB").append(condition).append(".W").toString(), new ARMSxtabTranslator());
                String string133 = String.valueOf(condition);
                translators.put(string133.length() != 0 ? "SXTAH".concat(string133) : new String("SXTAH"), new ARMSxtahTranslator());
                String string134 = String.valueOf(condition);
                translators.put(string134.length() != 0 ? "SXTB16".concat(string134) : new String("SXTB16"), new ARMSxtb16Translator());
                String string135 = String.valueOf(condition);
                translators.put(string135.length() != 0 ? "SXTB".concat(string135) : new String("SXTB"), new ARMSxtbTranslator());
                String string136 = String.valueOf(condition);
                translators.put(string136.length() != 0 ? "SXTH".concat(string136) : new String("SXTH"), new ARMSxthTranslator());
                String string137 = String.valueOf(condition);
                translators.put(string137.length() != 0 ? "TEQ".concat(string137) : new String("TEQ"), new ARMTeqTranslator());
                String string138 = String.valueOf(condition);
                translators.put(string138.length() != 0 ? "TST".concat(string138) : new String("TST"), new ARMTstTranslator());
                String string139 = String.valueOf(condition);
                translators.put(string139.length() != 0 ? "UADD16".concat(string139) : new String("UADD16"), new ARMUadd16Translator());
                String string140 = String.valueOf(condition);
                translators.put(string140.length() != 0 ? "UADD8".concat(string140) : new String("UADD8"), new ARMUadd8Translator());
                String string141 = String.valueOf(condition);
                translators.put(string141.length() != 0 ? "UADDSUBX".concat(string141) : new String("UADDSUBX"), new ARMUaddsubxTranslator());
                String string142 = String.valueOf(condition);
                translators.put(string142.length() != 0 ? "UASX".concat(string142) : new String("UASX"), new ARMUaddsubxTranslator());
                String string143 = String.valueOf(condition);
                translators.put(string143.length() != 0 ? "UHADD16".concat(string143) : new String("UHADD16"), new ARMUhadd16Translator());
                String string144 = String.valueOf(condition);
                translators.put(string144.length() != 0 ? "UHADD8".concat(string144) : new String("UHADD8"), new ARMUhadd8Translator());
                String string145 = String.valueOf(condition);
                translators.put(string145.length() != 0 ? "UHADDSUBX".concat(string145) : new String("UHADDSUBX"), new ARMUhaddsubxTranslator());
                String string146 = String.valueOf(condition);
                translators.put(string146.length() != 0 ? "UHASX".concat(string146) : new String("UHASX"), new ARMUhaddsubxTranslator());
                String string147 = String.valueOf(condition);
                translators.put(string147.length() != 0 ? "UHSUB16".concat(string147) : new String("UHSUB16"), new ARMUhsub16Translator());
                String string148 = String.valueOf(condition);
                translators.put(string148.length() != 0 ? "UHSUB8".concat(string148) : new String("UHSUB8"), new ARMUhsub8Translator());
                String string149 = String.valueOf(condition);
                translators.put(string149.length() != 0 ? "UHSUBADDX".concat(string149) : new String("UHSUBADDX"), new ARMUhsubaddxTranslator());
                String string150 = String.valueOf(condition);
                translators.put(string150.length() != 0 ? "UHSAX".concat(string150) : new String("UHSAX"), new ARMUhsubaddxTranslator());
                String string151 = String.valueOf(condition);
                translators.put(string151.length() != 0 ? "UMAAL".concat(string151) : new String("UMAAL"), new ARMUmaalTranslator());
                String string152 = String.valueOf(condition);
                translators.put(string152.length() != 0 ? "UMLAL".concat(string152) : new String("UMLAL"), new ARMUmlalTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("UMLAL").append(condition).append("S").toString(), new ARMUmlalTranslator());
                String string153 = String.valueOf(condition);
                translators.put(string153.length() != 0 ? "UMULL".concat(string153) : new String("UMULL"), new ARMUmullTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("UMULL").append(condition).append("S").toString(), new ARMUmullTranslator());
                String string154 = String.valueOf(condition);
                translators.put(string154.length() != 0 ? "UQADD16".concat(string154) : new String("UQADD16"), new ARMUqadd16Translator());
                String string155 = String.valueOf(condition);
                translators.put(string155.length() != 0 ? "UQADD8".concat(string155) : new String("UQADD8"), new ARMUqadd8Translator());
                String string156 = String.valueOf(condition);
                translators.put(string156.length() != 0 ? "UQADDSUBX".concat(string156) : new String("UQADDSUBX"), new ARMUqaddsubxTranslator());
                String string157 = String.valueOf(condition);
                translators.put(string157.length() != 0 ? "UQASX".concat(string157) : new String("UQASX"), new ARMUqaddsubxTranslator());
                String string158 = String.valueOf(condition);
                translators.put(string158.length() != 0 ? "UQSUB16".concat(string158) : new String("UQSUB16"), new ARMUqsub16Translator());
                String string159 = String.valueOf(condition);
                translators.put(string159.length() != 0 ? "UQSUB8".concat(string159) : new String("UQSUB8"), new ARMUqsub8Translator());
                String string160 = String.valueOf(condition);
                translators.put(string160.length() != 0 ? "UQSUBADDX".concat(string160) : new String("UQSUBADDX"), new ARMUqsubaddxTranslator());
                String string161 = String.valueOf(condition);
                translators.put(string161.length() != 0 ? "UQSAX".concat(string161) : new String("UQSAX"), new ARMUqsubaddxTranslator());
                String string162 = String.valueOf(condition);
                translators.put(string162.length() != 0 ? "USAD8".concat(string162) : new String("USAD8"), new ARMUsad8Translator());
                String string163 = String.valueOf(condition);
                translators.put(string163.length() != 0 ? "USADA8".concat(string163) : new String("USADA8"), new ARMUsada8Translator());
                String string164 = String.valueOf(condition);
                translators.put(string164.length() != 0 ? "USAT16".concat(string164) : new String("USAT16"), new ARMUsat16Translator());
                String string165 = String.valueOf(condition);
                translators.put(string165.length() != 0 ? "USAT".concat(string165) : new String("USAT"), new ARMUsatTranslator());
                String string166 = String.valueOf(condition);
                translators.put(string166.length() != 0 ? "USUB16".concat(string166) : new String("USUB16"), new ARMUsub16Translator());
                String string167 = String.valueOf(condition);
                translators.put(string167.length() != 0 ? "USUB8".concat(string167) : new String("USUB8"), new ARMUsub8Translator());
                String string168 = String.valueOf(condition);
                translators.put(string168.length() != 0 ? "USUBADDX".concat(string168) : new String("USUBADDX"), new ARMUsubaddxTranslator());
                String string169 = String.valueOf(condition);
                translators.put(string169.length() != 0 ? "USAX".concat(string169) : new String("USAX"), new ARMUsubaddxTranslator());
                String string170 = String.valueOf(condition);
                translators.put(string170.length() != 0 ? "UXTAB16".concat(string170) : new String("UXTAB16"), new ARMUxtab16Translator());
                String string171 = String.valueOf(condition);
                translators.put(string171.length() != 0 ? "UXTAB".concat(string171) : new String("UXTAB"), new ARMUxtabTranslator());
                String string172 = String.valueOf(condition);
                translators.put(string172.length() != 0 ? "UXTAH".concat(string172) : new String("UXTAH"), new ARMUxtahTranslator());
                String string173 = String.valueOf(condition);
                translators.put(string173.length() != 0 ? "UXTB16".concat(string173) : new String("UXTB16"), new ARMUxtb16Translator());
                String string174 = String.valueOf(condition);
                translators.put(string174.length() != 0 ? "UXTB".concat(string174) : new String("UXTB"), new ARMUxtbTranslator());
                String string175 = String.valueOf(condition);
                translators.put(string175.length() != 0 ? "UXTH".concat(string175) : new String("UXTH"), new ARMUxthTranslator());
                String string176 = String.valueOf(condition);
                translators.put(string176.length() != 0 ? "THUMBADCS".concat(string176) : new String("THUMBADCS"), new THUMBAdcTranslator());
                String string177 = String.valueOf(condition);
                translators.put(string177.length() != 0 ? "THUMBADC".concat(string177) : new String("THUMBADC"), new THUMBAdcTranslator());
                String string178 = String.valueOf(condition);
                translators.put(string178.length() != 0 ? "THUMBADDS".concat(string178) : new String("THUMBADDS"), new THUMBAddTranslator());
                String string179 = String.valueOf(condition);
                translators.put(string179.length() != 0 ? "THUMBADD".concat(string179) : new String("THUMBADD"), new THUMBAddTranslator());
                String string180 = String.valueOf(condition);
                translators.put(string180.length() != 0 ? "THUMBADDW".concat(string180) : new String("THUMBADDW"), new THUMBAddTranslator());
                String string181 = String.valueOf(condition);
                translators.put(string181.length() != 0 ? "THUMBADR".concat(string181) : new String("THUMBADR"), new ARMAdrTranslator());
                String string182 = String.valueOf(condition);
                translators.put(string182.length() != 0 ? "THUMBANDS".concat(string182) : new String("THUMBANDS"), new THUMBAndTranslator());
                String string183 = String.valueOf(condition);
                translators.put(string183.length() != 0 ? "THUMBAND".concat(string183) : new String("THUMBAND"), new THUMBAndTranslator());
                String string184 = String.valueOf(condition);
                translators.put(string184.length() != 0 ? "THUMBASRS".concat(string184) : new String("THUMBASRS"), new THUMBAsrTranslator());
                String string185 = String.valueOf(condition);
                translators.put(string185.length() != 0 ? "THUMBASR".concat(string185) : new String("THUMBASR"), new THUMBAsrTranslator());
                String string186 = String.valueOf(condition);
                translators.put(string186.length() != 0 ? "THUMBBICS".concat(string186) : new String("THUMBBICS"), new THUMBBicTranslator());
                String string187 = String.valueOf(condition);
                translators.put(string187.length() != 0 ? "THUMBBIC".concat(string187) : new String("THUMBBIC"), new THUMBBicTranslator());
                String string188 = String.valueOf(condition);
                translators.put(string188.length() != 0 ? "THUMBBKPT".concat(string188) : new String("THUMBBKPT"), new THUMBBkptTranslator());
                String string189 = String.valueOf(condition);
                translators.put(string189.length() != 0 ? "THUMBBL".concat(string189) : new String("THUMBBL"), new THUMBBlTranslator());
                String string190 = String.valueOf(condition);
                translators.put(string190.length() != 0 ? "THUMBBLX".concat(string190) : new String("THUMBBLX"), new THUMBBlTranslator());
                String string191 = String.valueOf(condition);
                translators.put(string191.length() != 0 ? "THUMBB".concat(string191) : new String("THUMBB"), new THUMBBTranslator());
                String string192 = String.valueOf(condition);
                translators.put(string192.length() != 0 ? "THUMBBX".concat(string192) : new String("THUMBBX"), new THUMBBxTranslator());
                String string193 = String.valueOf(condition);
                translators.put(string193.length() != 0 ? "THUMBCMN".concat(string193) : new String("THUMBCMN"), new THUMBCmnTranslator());
                String string194 = String.valueOf(condition);
                translators.put(string194.length() != 0 ? "THUMBCMP".concat(string194) : new String("THUMBCMP"), new THUMBCmpTranslator());
                String string195 = String.valueOf(condition);
                translators.put(string195.length() != 0 ? "THUMBCPS".concat(string195) : new String("THUMBCPS"), new THUMBCpsTranslator());
                String string196 = String.valueOf(condition);
                translators.put(string196.length() != 0 ? "THUMBCPY".concat(string196) : new String("THUMBCPY"), new THUMBCpyTranslator());
                String string197 = String.valueOf(condition);
                translators.put(string197.length() != 0 ? "THUMBEORS".concat(string197) : new String("THUMBEORS"), new THUMBEorTranslator());
                String string198 = String.valueOf(condition);
                translators.put(string198.length() != 0 ? "THUMBEOR".concat(string198) : new String("THUMBEOR"), new THUMBEorTranslator());
                String string199 = String.valueOf(condition);
                translators.put(string199.length() != 0 ? "THUMBLDMIA".concat(string199) : new String("THUMBLDMIA"), new THUMBLdmiaTranslator());
                String string200 = String.valueOf(condition);
                translators.put(string200.length() != 0 ? "THUMBLDRB".concat(string200) : new String("THUMBLDRB"), new THUMBLdrbTranslator());
                String string201 = String.valueOf(condition);
                translators.put(string201.length() != 0 ? "THUMBLDRH".concat(string201) : new String("THUMBLDRH"), new THUMBLdrhTranslator());
                String string202 = String.valueOf(condition);
                translators.put(string202.length() != 0 ? "THUMBLDRSB".concat(string202) : new String("THUMBLDRSB"), new THUMBLdrsbTranslator());
                String string203 = String.valueOf(condition);
                translators.put(string203.length() != 0 ? "THUMBLDRSH".concat(string203) : new String("THUMBLDRSH"), new THUMBLdrshTranslator());
                String string204 = String.valueOf(condition);
                translators.put(string204.length() != 0 ? "THUMBLDR".concat(string204) : new String("THUMBLDR"), new THUMBLdrTranslator());
                String string205 = String.valueOf(condition);
                translators.put(string205.length() != 0 ? "THUMBLSLS".concat(string205) : new String("THUMBLSLS"), new THUMBLslTranslator());
                String string206 = String.valueOf(condition);
                translators.put(string206.length() != 0 ? "THUMBLSL".concat(string206) : new String("THUMBLSL"), new THUMBLslTranslator());
                String string207 = String.valueOf(condition);
                translators.put(string207.length() != 0 ? "THUMBLSRS".concat(string207) : new String("THUMBLSRS"), new THUMBLsrTranslator());
                String string208 = String.valueOf(condition);
                translators.put(string208.length() != 0 ? "THUMBLSR".concat(string208) : new String("THUMBLSR"), new THUMBLsrTranslator());
                String string209 = String.valueOf(condition);
                translators.put(string209.length() != 0 ? "THUMBMOVS".concat(string209) : new String("THUMBMOVS"), new THUMBMovTranslator());
                String string210 = String.valueOf(condition);
                translators.put(string210.length() != 0 ? "THUMBMOV".concat(string210) : new String("THUMBMOV"), new THUMBMovTranslator());
                String string211 = String.valueOf(condition);
                translators.put(string211.length() != 0 ? "THUMBMUL".concat(string211) : new String("THUMBMUL"), new THUMBMulTranslator());
                String string212 = String.valueOf(condition);
                translators.put(string212.length() != 0 ? "THUMBMULS".concat(string212) : new String("THUMBMULS"), new THUMBMulTranslator());
                String string213 = String.valueOf(condition);
                translators.put(string213.length() != 0 ? "THUMBMVNS".concat(string213) : new String("THUMBMVNS"), new THUMBMvnTranslator());
                String string214 = String.valueOf(condition);
                translators.put(string214.length() != 0 ? "THUMBNEGS".concat(string214) : new String("THUMBNEGS"), new THUMBNegTranslator());
                String string215 = String.valueOf(condition);
                translators.put(string215.length() != 0 ? "THUMBNEG".concat(string215) : new String("THUMBNEG"), new THUMBNegTranslator());
                String string216 = String.valueOf(condition);
                translators.put(string216.length() != 0 ? "THUMBORRS".concat(string216) : new String("THUMBORRS"), new THUMBOrrTranslator());
                String string217 = String.valueOf(condition);
                translators.put(string217.length() != 0 ? "THUMBORR".concat(string217) : new String("THUMBORR"), new THUMBOrrTranslator());
                String string218 = String.valueOf(condition);
                translators.put(string218.length() != 0 ? "THUMBPOP".concat(string218) : new String("THUMBPOP"), new THUMBPopTranslator());
                String string219 = String.valueOf(condition);
                translators.put(string219.length() != 0 ? "THUMBPUSH".concat(string219) : new String("THUMBPUSH"), new THUMBPushTranslator());
                String string220 = String.valueOf(condition);
                translators.put(string220.length() != 0 ? "THUMBREV16".concat(string220) : new String("THUMBREV16"), new THUMBRev16Translator());
                String string221 = String.valueOf(condition);
                translators.put(string221.length() != 0 ? "THUMBREVSH".concat(string221) : new String("THUMBREVSH"), new THUMBRevshTranslator());
                String string222 = String.valueOf(condition);
                translators.put(string222.length() != 0 ? "THUMBREV".concat(string222) : new String("THUMBREV"), new THUMBRevTranslator());
                String string223 = String.valueOf(condition);
                translators.put(string223.length() != 0 ? "THUMBRORS".concat(string223) : new String("THUMBRORS"), new THUMBRorTranslator());
                String string224 = String.valueOf(condition);
                translators.put(string224.length() != 0 ? "THUMBSBCS".concat(string224) : new String("THUMBSBCS"), new THUMBSbcTranslator());
                String string225 = String.valueOf(condition);
                translators.put(string225.length() != 0 ? "THUMBSETEND".concat(string225) : new String("THUMBSETEND"), new THUMBSetendTranslator());
                String string226 = String.valueOf(condition);
                translators.put(string226.length() != 0 ? "THUMBSTMIA".concat(string226) : new String("THUMBSTMIA"), new THUMBStmiaTranslator());
                translators.put(new StringBuilder(9 + String.valueOf(condition).length()).append("THUMBSTR").append(condition).append("B").toString(), new THUMBStrbTranslator());
                String string227 = String.valueOf(condition);
                translators.put(string227.length() != 0 ? "THUMBSTRH".concat(string227) : new String("THUMBSTRH"), new THUMBStrhTranslator());
                String string228 = String.valueOf(condition);
                translators.put(string228.length() != 0 ? "THUMBSTR".concat(string228) : new String("THUMBSTR"), new THUMBStrTranslator());
                String string229 = String.valueOf(condition);
                translators.put(string229.length() != 0 ? "THUMBSUBS".concat(string229) : new String("THUMBSUBS"), new THUMBSubTranslator());
                String string230 = String.valueOf(condition);
                translators.put(string230.length() != 0 ? "THUMBSUB".concat(string230) : new String("THUMBSUB"), new THUMBSubTranslator());
                String string231 = String.valueOf(condition);
                translators.put(string231.length() != 0 ? "THUMBSWI".concat(string231) : new String("THUMBSWI"), new THUMBSwiTranslator());
                String string232 = String.valueOf(condition);
                translators.put(string232.length() != 0 ? "THUMBSXTB".concat(string232) : new String("THUMBSXTB"), new THUMBSxtbTranslator());
                String string233 = String.valueOf(condition);
                translators.put(string233.length() != 0 ? "THUMBSXTH".concat(string233) : new String("THUMBSXTH"), new THUMBSxthTranslator());
                String string234 = String.valueOf(condition);
                translators.put(string234.length() != 0 ? "THUMBUXTB".concat(string234) : new String("THUMBUXTB"), new THUMBUxtbTranslator());
                String string235 = String.valueOf(condition);
                translators.put(string235.length() != 0 ? "THUMBUXTH".concat(string235) : new String("THUMBUXTH"), new THUMBUxthTranslator());
                String string236 = String.valueOf(condition);
                translators.put(string236.length() != 0 ? "THUMBTST".concat(string236) : new String("THUMBTST"), new THUMBTstTranslator());
                String string237 = String.valueOf(condition);
                translators.put(string237.length() != 0 ? "THUMBNOP".concat(string237) : new String("THUMBNOP"), new THUMBNopTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("ADD").append(condition).append(".W").toString(), new ARMAddTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("ADD").append(condition).append("S.W").toString(), new ARMAddTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("ADC").append(condition).append(".W").toString(), new ARMAdcTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("ADC").append(condition).append("S.W").toString(), new ARMAdcTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("ADC").append(condition).append("S.W").toString(), new ARMAdcTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("ADR").append(condition).append(".W").toString(), new ARMAdrTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("AND").append(condition).append(".W").toString(), new ARMAndTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("AND").append(condition).append("S.W").toString(), new ARMAndTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("AST").append(condition).append(".W").toString(), new THUMBAsrTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("ASR").append(condition).append(".W").toString(), new THUMBAsrTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("ASR").append(condition).append("S.W").toString(), new THUMBAsrTranslator());
                String string238 = String.valueOf(condition);
                translators.put(string238.length() != 0 ? "ASR".concat(string238) : new String("ASR"), new THUMBAsrTranslator());
                translators.put(new StringBuilder(3 + String.valueOf(condition).length()).append("B").append(condition).append(".W").toString(), new THUMBBTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("BIC").append(condition).append(".W").toString(), new THUMBBicTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("BIC").append(condition).append("S.W").toString(), new THUMBBicTranslator());
                String string239 = String.valueOf(condition);
                translators.put(string239.length() != 0 ? "BFC".concat(string239) : new String("BFC"), new THUMB2BFCTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("BFC").append(condition).append(".W").toString(), new THUMB2BFCTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("BFC").append(condition).append("S.W").toString(), new THUMB2BFCTranslator());
                String string240 = String.valueOf(condition);
                translators.put(string240.length() != 0 ? "BFI".concat(string240) : new String("BFI"), new THUMB2BFITranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("BFI").append(condition).append(".W").toString(), new THUMB2BFITranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("BFI").append(condition).append("S.W").toString(), new THUMB2BFITranslator());
                translators.put("THUMBCBZ", new THUMB2CbzTranslator());
                translators.put("THUMBCBNZ", new THUMB2CbnzTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("CLZ").append(condition).append(".W").toString(), new ARMClzTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("CMN").append(condition).append(".W").toString(), new ARMCmnTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("CMN").append(condition).append("S.W").toString(), new ARMCmnTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("CMP").append(condition).append(".W").toString(), new ARMCmpTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("EOR").append(condition).append(".W").toString(), new ARMEorTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("EOR").append(condition).append("S.W").toString(), new ARMEorTranslator());
                String string241 = String.valueOf(condition);
                translators.put(string241.length() != 0 ? "THUMBIT ".concat(string241) : new String("THUMBIT "), new THUMB2ItTranslator());
                String string242 = String.valueOf(condition);
                translators.put(string242.length() != 0 ? "THUMBITT ".concat(string242) : new String("THUMBITT "), new THUMB2ItTranslator());
                String string243 = String.valueOf(condition);
                translators.put(string243.length() != 0 ? "THUMBITTT ".concat(string243) : new String("THUMBITTT "), new THUMB2ItTranslator());
                String string244 = String.valueOf(condition);
                translators.put(string244.length() != 0 ? "THUMBITTTT ".concat(string244) : new String("THUMBITTTT "), new THUMB2ItTranslator());
                String string245 = String.valueOf(condition);
                translators.put(string245.length() != 0 ? "THUMBITE ".concat(string245) : new String("THUMBITE "), new THUMB2ItTranslator());
                String string246 = String.valueOf(condition);
                translators.put(string246.length() != 0 ? "THUMBITEE ".concat(string246) : new String("THUMBITEE "), new THUMB2ItTranslator());
                String string247 = String.valueOf(condition);
                translators.put(string247.length() != 0 ? "THUMBITEEE ".concat(string247) : new String("THUMBITEEE "), new THUMB2ItTranslator());
                String string248 = String.valueOf(condition);
                translators.put(string248.length() != 0 ? "THUMBITEET ".concat(string248) : new String("THUMBITEET "), new THUMB2ItTranslator());
                String string249 = String.valueOf(condition);
                translators.put(string249.length() != 0 ? "THUMBITETE ".concat(string249) : new String("THUMBITETE "), new THUMB2ItTranslator());
                String string250 = String.valueOf(condition);
                translators.put(string250.length() != 0 ? "THUMBITETT ".concat(string250) : new String("THUMBITETT "), new THUMB2ItTranslator());
                String string251 = String.valueOf(condition);
                translators.put(string251.length() != 0 ? "THUMBITET ".concat(string251) : new String("THUMBITET "), new THUMB2ItTranslator());
                String string252 = String.valueOf(condition);
                translators.put(string252.length() != 0 ? "THUMBITT ".concat(string252) : new String("THUMBITT "), new THUMB2ItTranslator());
                String string253 = String.valueOf(condition);
                translators.put(string253.length() != 0 ? "THUMBITTE ".concat(string253) : new String("THUMBITTE "), new THUMB2ItTranslator());
                String string254 = String.valueOf(condition);
                translators.put(string254.length() != 0 ? "THUMBITTEE ".concat(string254) : new String("THUMBITTEE "), new THUMB2ItTranslator());
                String string255 = String.valueOf(condition);
                translators.put(string255.length() != 0 ? "THUMBITTET ".concat(string255) : new String("THUMBITTET "), new THUMB2ItTranslator());
                String string256 = String.valueOf(condition);
                translators.put(string256.length() != 0 ? "THUMBITTT ".concat(string256) : new String("THUMBITTT "), new THUMB2ItTranslator());
                String string257 = String.valueOf(condition);
                translators.put(string257.length() != 0 ? "THUMBITTTE ".concat(string257) : new String("THUMBITTTE "), new THUMB2ItTranslator());
                String string258 = String.valueOf(condition);
                translators.put(string258.length() != 0 ? "THUMBITTTT ".concat(string258) : new String("THUMBITTTT "), new THUMB2ItTranslator());
                for (String multiRegisterInstruction : multiRegisterInstructions) {
                    translators.put(new StringBuilder(5 + String.valueOf(condition).length() + String.valueOf(multiRegisterInstruction).length()).append("LDM").append(condition).append(multiRegisterInstruction).append(".W").toString(), new ARMLdmTranslator());
                }
                String string259 = String.valueOf(matchLDR);
                translators.put(new StringBuilder(2 + String.valueOf(string259).length() + String.valueOf(condition).length()).append(string259).append(condition).append(".W").toString(), new ARMLdrTranslator());
                String string260 = String.valueOf(matchLDR);
                translators.put(new StringBuilder(3 + String.valueOf(string260).length() + String.valueOf(condition).length()).append(string260).append(condition).append("B.W").toString(), new ARMLdrbTranslator());
                String string261 = String.valueOf(matchLDR);
                translators.put(new StringBuilder(3 + String.valueOf(string261).length() + String.valueOf(condition).length()).append(string261).append(condition).append("D.W").toString(), new THUMB2LDRDTranslator());
                String string262 = String.valueOf("LDRD");
                translators.put(new StringBuilder(2 + String.valueOf(string262).length() + String.valueOf(condition).length()).append(string262).append(condition).append(".W").toString(), new THUMB2LDRDTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("LDRD").append(condition).append(".W").toString(), new THUMB2LDRDTranslator());
                translators.put(new StringBuilder(9 + String.valueOf(condition).length()).append("THUMBLDR").append(condition).append("B").toString(), new ARMLdrbTranslator());
                String string263 = String.valueOf(matchLDR);
                translators.put(new StringBuilder(3 + String.valueOf(string263).length() + String.valueOf(condition).length()).append(string263).append(condition).append("H.W").toString(), new ARMLdrhTranslator());
                translators.put(new StringBuilder(9 + String.valueOf(condition).length()).append("THUMBLDR").append(condition).append("H").toString(), new ARMLdrhTranslator());
                translators.put(new StringBuilder(8 + String.valueOf(condition).length()).append("LDRHT").append(condition).append("S.W").toString(), new ARMLdrhtTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("LDRHT").append(condition).append(".W").toString(), new ARMLdrhtTranslator());
                String string264 = String.valueOf(condition);
                translators.put(string264.length() != 0 ? "LDRHT".concat(string264) : new String("LDRHT"), new ARMLdrhtTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("LDRSB").append(condition).append(".W").toString(), new ARMLdrsbTranslator());
                translators.put(new StringBuilder(9 + String.valueOf(condition).length()).append("LDRSBT").append(condition).append("S.W").toString(), new ARMLdrsbTranslator());
                translators.put(new StringBuilder(8 + String.valueOf(condition).length()).append("LDRSBT").append(condition).append(".W").toString(), new ARMLdrsbTranslator());
                String string265 = String.valueOf(condition);
                translators.put(string265.length() != 0 ? "LDRSBT".concat(string265) : new String("LDRSBT"), new ARMLdrsbTranslator());
                String string266 = String.valueOf(condition);
                translators.put(string266.length() != 0 ? "LDRSH".concat(string266) : new String("LDRSH"), new ARMLdrshTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("LDRSH").append(condition).append(".W").toString(), new ARMLdrshTranslator());
                String string267 = String.valueOf(condition);
                translators.put(string267.length() != 0 ? "LDRSHT".concat(string267) : new String("LDRSHT"), new ARMLdrshTranslator());
                translators.put(new StringBuilder(8 + String.valueOf(condition).length()).append("LDRSHT").append(condition).append(".W").toString(), new ARMLdrshTranslator());
                translators.put(new StringBuilder(9 + String.valueOf(condition).length()).append("LDRSHT").append(condition).append("S.W").toString(), new ARMLdrshTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("LSL").append(condition).append(".W").toString(), new THUMBLslTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("LSL").append(condition).append("S.W").toString(), new THUMBLslTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("LSR").append(condition).append(".W").toString(), new THUMBLsrTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("LSR").append(condition).append("S.W").toString(), new THUMBLsrTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("MLA").append(condition).append(".W").toString(), new ARMMlaTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("MLS").append(condition).append(".W").toString(), new THUMB2MlsTranslator());
                String string268 = String.valueOf(condition);
                translators.put(string268.length() != 0 ? "MLS".concat(string268) : new String("MLS"), new THUMB2MlsTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("MOV").append(condition).append(".W").toString(), new ARMMovTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("MOV").append(condition).append("S.W").toString(), new ARMMovTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("MOV").append(condition).append("W").toString(), new ARMMovTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("MOVT").append(condition).append(".W").toString(), new THUMB2MovtTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("MOVT").append(condition).append("S.W").toString(), new THUMB2MovtTranslator());
                String string269 = String.valueOf(condition);
                translators.put(string269.length() != 0 ? "MOVT".concat(string269) : new String("MOVT"), new THUMB2MovtTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("MUL").append(condition).append(".W").toString(), new ARMMulTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("MVN").append(condition).append(".W").toString(), new ARMMvnTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("MVN").append(condition).append("S.W").toString(), new ARMMvnTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("ORR").append(condition).append(".W").toString(), new ARMOrrTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("ORR").append(condition).append("S.W").toString(), new ARMOrrTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("ORN").append(condition).append(".W").toString(), new ARMOrnTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("ORN").append(condition).append("S.W").toString(), new ARMOrnTranslator());
                String string270 = String.valueOf(condition);
                translators.put(string270.length() != 0 ? "ORN".concat(string270) : new String("ORN"), new ARMOrnTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("ORN").append(condition).append("S").toString(), new ARMOrnTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("POP").append(condition).append(".W").toString(), new THUMBPopTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("PUSH").append(condition).append(".W").toString(), new THUMBPushTranslator());
                String string271 = String.valueOf(condition);
                translators.put(string271.length() != 0 ? "RBIT".concat(string271) : new String("RBIT"), new THUMB2RBITTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("RBIT").append(condition).append(".W").toString(), new THUMB2RBITTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("RBIT").append(condition).append("S.W").toString(), new THUMB2RBITTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("ROR").append(condition).append(".W").toString(), new THUMBRorTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("ROR").append(condition).append("S.W").toString(), new THUMBRorTranslator());
                String string272 = String.valueOf(condition);
                translators.put(string272.length() != 0 ? "RRX".concat(string272) : new String("RRX"), new ARMRrxTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("RRX").append(condition).append("S.W").toString(), new ARMRrxTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("RRX").append(condition).append("S.W").toString(), new ARMRrxTranslator());
                translators.put(new StringBuilder(4 + String.valueOf(condition).length()).append("RRX").append(condition).append("S").toString(), new ARMRrxTranslator());
                String string273 = String.valueOf(condition);
                translators.put(string273.length() != 0 ? "RRXS".concat(string273) : new String("RRXS"), new ARMRrxTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("RSB").append(condition).append(".W").toString(), new ARMRsbTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("RSB").append(condition).append("S.W").toString(), new ARMRsbTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("TEQ").append(condition).append(".W").toString(), new ARMTeqTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("TBB").append(condition).append(".W").toString(), new THUMB2TbbTranslator());
                String string274 = String.valueOf(condition);
                translators.put(string274.length() != 0 ? "TBB".concat(string274) : new String("TBB"), new THUMB2TbbTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("TBH").append(condition).append(".W").toString(), new THUMB2TbhTranslator());
                String string275 = String.valueOf(condition);
                translators.put(string275.length() != 0 ? "TBH".concat(string275) : new String("TBH"), new THUMB2TbhTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("SBC").append(condition).append(".W").toString(), new ARMSbcTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("SBC").append(condition).append("S.W").toString(), new ARMSbcTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("SBFX").append(condition).append("S.W").toString(), new ARMSBFXTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("SBFX").append(condition).append(".W").toString(), new ARMSBFXTranslator());
                String string276 = String.valueOf(condition);
                translators.put(string276.length() != 0 ? "SBFX".concat(string276) : new String("SBFX"), new ARMSBFXTranslator());
                String string277 = String.valueOf(condition);
                translators.put(string277.length() != 0 ? "SDIV".concat(string277) : new String("SDIV"), new ARMSdivTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("SDIV").append(condition).append(".W").toString(), new ARMSdivTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("SDIV").append(condition).append("S.W").toString(), new ARMSdivTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("SMLAL").append(condition).append(".W").toString(), new ARMSmlalTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("SMULL").append(condition).append(".W").toString(), new ARMSmullTranslator());
                for (String multiRegisterInstruction : multiRegisterInstructions) {
                    translators.put(new StringBuilder(5 + String.valueOf(condition).length() + String.valueOf(multiRegisterInstruction).length()).append("STM").append(condition).append(multiRegisterInstruction).append(".W").toString(), new ARMStmTranslator());
                }
                String string278 = String.valueOf("STRB");
                translators.put(new StringBuilder(2 + String.valueOf(string278).length() + String.valueOf(condition).length()).append(string278).append(condition).append(".W").toString(), new ARMStrbTranslator());
                String string279 = String.valueOf("STRH");
                translators.put(new StringBuilder(2 + String.valueOf(string279).length() + String.valueOf(condition).length()).append(string279).append(condition).append(".W").toString(), new ARMStrhTranslator());
                String string280 = String.valueOf("STRD");
                translators.put(new StringBuilder(2 + String.valueOf(string280).length() + String.valueOf(condition).length()).append(string280).append(condition).append(".W").toString(), new THUMB2STRDTranslator());
                String string281 = String.valueOf(matchSTR);
                translators.put(new StringBuilder(3 + String.valueOf(string281).length() + String.valueOf(condition).length()).append(string281).append(condition).append("D.W").toString(), new THUMB2STRDTranslator());
                String string282 = String.valueOf(matchSTR);
                translators.put(new StringBuilder(3 + String.valueOf(string282).length() + String.valueOf(condition).length()).append(string282).append(condition).append("B.W").toString(), new ARMStrbTranslator());
                String string283 = String.valueOf(matchSTR);
                translators.put(new StringBuilder(3 + String.valueOf(string283).length() + String.valueOf(condition).length()).append(string283).append(condition).append("H.W").toString(), new ARMStrhTranslator());
                String object = String.valueOf(matchSTR);
                translators.put(new StringBuilder(2 + String.valueOf(object).length() + String.valueOf(condition).length()).append(object).append(condition).append(".W").toString(), new ARMStrTranslator());
                translators.put(new StringBuilder(8 + String.valueOf(condition).length()).append("STRHT").append(condition).append("S.W").toString(), new ARMStrhTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("STRHT").append(condition).append("W").toString(), new ARMStrhTranslator());
                String string284 = String.valueOf(condition);
                translators.put(string284.length() != 0 ? "STRHT".concat(string284) : new String("STRHT"), new ARMStrhTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("SUB").append(condition).append(".W").toString(), new ARMSubTranslator());
                String string285 = String.valueOf(condition);
                translators.put(string285.length() != 0 ? "SUBW".concat(string285) : new String("SUBW"), new ARMSubTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("SUBS").append(condition).append(".W").toString(), new ARMSubTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("SUB").append(condition).append("S.W").toString(), new ARMSubTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("SXTB").append(condition).append(".W").toString(), new ARMSxtbTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("SXTH").append(condition).append(".W").toString(), new ARMSxthTranslator());
                translators.put(new StringBuilder(5 + String.valueOf(condition).length()).append("TST").append(condition).append(".W").toString(), new ARMTstTranslator());
                String string286 = String.valueOf(condition);
                translators.put(string286.length() != 0 ? "UBFX".concat(string286) : new String("UBFX"), new ARMUBFXTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("UBFX").append(condition).append("S.W").toString(), new ARMUBFXTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("UBFX").append(condition).append(".W").toString(), new ARMUBFXTranslator());
                String string287 = String.valueOf(condition);
                translators.put(string287.length() != 0 ? "UDIV".concat(string287) : new String("UDIV"), new ARMUdivTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("UDIV").append(condition).append(".W").toString(), new ARMUdivTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("UDIV").append(condition).append("S.W").toString(), new ARMUdivTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("UMLAL").append(condition).append(".W").toString(), new ARMUmlalTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("UMULL").append(condition).append(".W").toString(), new ARMUmullTranslator());
                translators.put(new StringBuilder(7 + String.valueOf(condition).length()).append("UXTAH").append(condition).append(".W").toString(), new ARMUxtahTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("UXTB").append(condition).append(".W").toString(), new ARMUxtbTranslator());
                translators.put(new StringBuilder(6 + String.valueOf(condition).length()).append("UXTH").append(condition).append(".W").toString(), new ARMUxthTranslator());
            }
            translators.put("FABSD", new ARMNopTranslator());
            translators.put("FABSDEQ", new ARMNopTranslator());
            translators.put("FABSS", new ARMNopTranslator());
            translators.put("FADDD", new ARMNopTranslator());
            translators.put("FADDDGT", new ARMNopTranslator());
            translators.put("FADDDLT", new ARMNopTranslator());
            translators.put("FADDDNE", new ARMNopTranslator());
            translators.put("FADDDPL", new ARMNopTranslator());
            translators.put("FADDS", new ARMNopTranslator());
            translators.put("FCMPD", new ARMNopTranslator());
            translators.put("FCMPED", new ARMNopTranslator());
            translators.put("FCMPEZD", new ARMNopTranslator());
            translators.put("FCMPEZS", new ARMNopTranslator());
            translators.put("FCMPS", new ARMNopTranslator());
            translators.put("FCMPZD", new ARMNopTranslator());
            translators.put("FCPYD", new ARMNopTranslator());
            translators.put("FCPYDGT", new ARMNopTranslator());
            translators.put("FCPYDLE", new ARMNopTranslator());
            translators.put("FCPYDLT", new ARMNopTranslator());
            translators.put("FCPYDNE", new ARMNopTranslator());
            translators.put("FCPYS", new ARMNopTranslator());
            translators.put("FCVTDS", new ARMNopTranslator());
            translators.put("FCVTSD", new ARMNopTranslator());
            translators.put("FDIVD", new ARMNopTranslator());
            translators.put("FDIVDNE", new ARMNopTranslator());
            translators.put("FDIVS", new ARMNopTranslator());
            translators.put("FLDD", new ARMNopTranslator());
            translators.put("FLDMEAD", new ARMNopTranslator());
            translators.put("FLDMIAX", new ARMNopTranslator());
            translators.put("FLDS", new ARMNopTranslator());
            translators.put("FMACD", new ARMNopTranslator());
            translators.put("FMDHR", new ARMNopTranslator());
            translators.put("FMDLR", new ARMNopTranslator());
            translators.put("FMDRR", new ARMNopTranslator());
            translators.put("FMRRD", new ARMNopTranslator());
            translators.put("FMRRDGE", new ARMNopTranslator());
            translators.put("FMRS", new ARMNopTranslator());
            translators.put("FMRSNE", new ARMNopTranslator());
            translators.put("FMRSPL", new ARMNopTranslator());
            translators.put("FMRX", new ARMNopTranslator());
            translators.put("FMSCD", new ARMNopTranslator());
            translators.put("FMSR", new ARMNopTranslator());
            translators.put("FMSRNE", new ARMNopTranslator());
            translators.put("FMSTAT", new ARMNopTranslator());
            translators.put("FMULD", new ARMNopTranslator());
            translators.put("FMULDNE", new ARMNopTranslator());
            translators.put("FMULS", new ARMNopTranslator());
            translators.put("FMXR", new ARMNopTranslator());
            translators.put("FNEGD", new ARMNopTranslator());
            translators.put("FNEGDLE", new ARMNopTranslator());
            translators.put("FNEGDLT", new ARMNopTranslator());
            translators.put("FNEGDMI", new ARMNopTranslator());
            translators.put("FNMACD", new ARMNopTranslator());
            translators.put("FNMACDLT", new ARMNopTranslator());
            translators.put("FSITOD", new ARMNopTranslator());
            translators.put("FSITOS", new ARMNopTranslator());
            translators.put("FSQRTD", new ARMNopTranslator());
            translators.put("FSQRTS", new ARMNopTranslator());
            translators.put("FSTD", new ARMNopTranslator());
            translators.put("FSTMIAX", new ARMNopTranslator());
            translators.put("FSUBD", new ARMNopTranslator());
            translators.put("FSUBDEQ", new ARMNopTranslator());
            translators.put("FSUBDGT", new ARMNopTranslator());
            translators.put("FSUBDPL", new ARMNopTranslator());
            translators.put("FSUBS", new ARMNopTranslator());
            translators.put("FTOSID", new ARMNopTranslator());
            translators.put("FTOSIS", new ARMNopTranslator());
            translators.put("FTOSIZD", new ARMNopTranslator());
            translators.put("FTOSIZDPL", new ARMNopTranslator());
            translators.put("FTOSIZS", new ARMNopTranslator());
            translators.put("FTOUIZD", new ARMNopTranslator());
            translators.put("FTOUIZS", new ARMNopTranslator());
            translators.put("FUITOD", new ARMNopTranslator());
            translators.put("FUITOS", new ARMNopTranslator());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

