/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class THUMBTstTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        String sourceRegister1 = registerOperand1.getValue();
        String sourceRegister2 = registerOperand2.getValue();
        OperandSize dw = OperandSize.DWORD;
        OperandSize wd = OperandSize.WORD;
        OperandSize bt2 = OperandSize.BYTE;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String tmpVar = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, dw, sourceRegister2, dw, tmpVar));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar, wd, String.valueOf(-31L), bt2, "N"));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dw, tmpVar, bt2, "Z"));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "TST");
        this.translateAll(environment, instruction, "TST", instructions);
    }
}

