/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class THUMBSbcTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister = registerOperand2.getValue();
        OperandSize dw = OperandSize.DWORD;
        OperandSize wd = OperandSize.WORD;
        OperandSize bt2 = OperandSize.BYTE;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String notCFlag = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, "C", bt2, notCFlag));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, targetRegister, bt2, notCFlag, dw, tmpVar1));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpVar1, bt2, sourceRegister, dw, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar2, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, targetRegister, wd, String.valueOf(-31), bt2, "N"));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dw, targetRegister, bt2, "Z"));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar2, wd, String.valueOf(-31L), bt2, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar3, bt2, String.valueOf(1L), bt2, tmpVar4));
        instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, tmpVar4, bt2, "C"));
        Helpers.subOverflow(baseOffset, environment, instruction, instructions, dw, tmpVar1, bt2, sourceRegister, dw, tmpVar2, "V", 32L);
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SBC");
        this.translateAll(environment, instruction, "SBC", instructions);
    }
}

