/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class THUMBRevTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister = registerOperand2.getValue();
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String tmpRm7to0 = environment.getNextVariableString();
        String tmpRm15to8 = environment.getNextVariableString();
        String tmpRm23to16 = environment.getNextVariableString();
        String tmpRm31to24 = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String tmpVar5 = environment.getNextVariableString();
        String tmpVar6 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister, dw, String.valueOf(255L), dw, tmpRm7to0));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpRm7to0, dw, String.valueOf(24), dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister, dw, String.valueOf(65280L), dw, tmpRm15to8));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpRm15to8, dw, String.valueOf(8), dw, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister, dw, String.valueOf(0xFF0000L), dw, tmpRm23to16));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpRm23to16, dw, String.valueOf(-8), dw, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister, dw, String.valueOf(0xFF0000L), dw, tmpRm31to24));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpRm31to24, dw, String.valueOf(-8), dw, tmpVar4));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpVar1, dw, tmpVar2, dw, tmpVar5));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpVar3, dw, tmpVar4, dw, tmpVar6));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpVar5, dw, tmpVar6, dw, targetRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "REV");
        this.translateAll(environment, instruction, "REV", instructions);
    }
}

