/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class THUMBPushTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        int registerListLength = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getChildren().size();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String tmpAddress = environment.getNextVariableString();
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, "SP", dw, String.valueOf(4 * registerListLength), dw, tmpAddress));
        for (int i2 = 0; i2 < registerListLength; ++i2) {
            instructions.add(ReilHelpers.createStm(baseOffset++, dw, instruction.getOperands().get(0).getRootNode().getChildren().get(0).getChildren().get(i2).getValue(), dw, tmpAddress));
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, tmpAddress, bt2, String.valueOf(4L), dw, tmpAddress));
        }
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, "SP", dw, String.valueOf(4 * registerListLength), dw, "SP"));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "PUSH");
        this.translateAll(environment, instruction, "PUSH", instructions);
    }
}

