/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMFlagSettingHelper;
import com.google.security.zynamics.reil.translators.arm.AddressingModeOneGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class THUMBLsrTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().size() == 3 ? instruction.getOperands().get(2).getRootNode().getChildren().get(0) : null;
        String sourceRegister1 = registerOperand1.getValue();
        String sourceRegister2 = registerOperand2.getValue();
        String sourceImmediate = instruction.getOperands().size() == 3 ? registerOperand3.getValue() : null;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Pair<String, String> result = null;
        if (instruction.getOperands().size() == 3) {
            result = instruction.getMnemonic().endsWith(".W") ? AddressingModeOneGenerator.lsrRegister(baseOffset, environment, instructions, sourceRegister2, sourceImmediate) : AddressingModeOneGenerator.lsrImmediate(baseOffset, environment, instructions, sourceRegister2, sourceImmediate);
        } else if (instruction.getOperands().size() == 2) {
            result = AddressingModeOneGenerator.lsrRegister(baseOffset, environment, instructions, sourceRegister1, sourceRegister2);
        }
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createAnd(baseOffset++, OperandSize.DWORD, result.first(), OperandSize.DWORD, String.valueOf(0xFFFFFFFFL), OperandSize.DWORD, sourceRegister1));
        if (instruction.getMnemonic().contains("LSRS")) {
            ARMFlagSettingHelper.setThumbRotateFlags(instructions, baseOffset, OperandSize.BYTE, result.second(), OperandSize.DWORD, result.first());
        }
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "LSR");
        this.translateAll(environment, instruction, "LSR", instructions);
    }
}

