/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.AddressingModeOneGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class THUMB2TbhTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        OperandSize dw = OperandSize.DWORD;
        OperandSize wd = OperandSize.WORD;
        OperandSize bt2 = OperandSize.BYTE;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getChildren().get(0).getChildren().get(0);
        IOperandTreeNode shifterRootOperand = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getChildren().get(0).getChildren().get(1);
        String firstRegister = registerOperand1.getValue();
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Pair<String, String> shifterOut = AddressingModeOneGenerator.generate(baseOffset, environment, instruction, instructions, shifterRootOperand);
        String memoryAddress = environment.getNextVariableString();
        String halfword = environment.getNextVariableString();
        String twoTimesHalfword = environment.getNextVariableString();
        String jumpTarget = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstRegister, dw, shifterOut.first(), dw, memoryAddress));
        instructions.add(ReilHelpers.createLdm(baseOffset++, dw, memoryAddress, wd, halfword));
        instructions.add(ReilHelpers.createMul(baseOffset++, wd, halfword, wd, String.valueOf(2), dw, twoTimesHalfword));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, "PC", dw, twoTimesHalfword, dw, jumpTarget));
        instructions.add(ReilHelpers.createJcc(baseOffset++, bt2, String.valueOf(1), dw, jumpTarget, new String[0]));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "TBH");
        this.translateAll(environment, instruction, "TBH", instructions);
    }
}

