/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class THUMB2MovtTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode immediateOperand1 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String immediateValue = immediateOperand1.getValue();
        OperandSize dw = OperandSize.DWORD;
        OperandSize wd = OperandSize.WORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBsh(baseOffset++, wd, immediateValue, wd, String.valueOf(16), dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, targetRegister, dw, String.valueOf(65535L), dw, tmpVar2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpVar1, dw, tmpVar2, dw, targetRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "MOVT");
        this.translateAll(environment, instruction, "MOVT", instructions);
    }
}

