/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class THUMB2MlsTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        OperandSize qw = OperandSize.QWORD;
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        IOperandTreeNode targetOperand = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode sourceOperand1 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode sourceOperand2 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        IOperandTreeNode sourceOperand3 = instruction.getOperands().get(3).getRootNode().getChildren().get(0);
        String targetRegister = targetOperand.getValue();
        String sourceRegister1 = sourceOperand1.getValue();
        String sourceRegister2 = sourceOperand2.getValue();
        String sourceRegister3 = sourceOperand3.getValue();
        String multiplicationResult = environment.getNextVariableString();
        String subtractionResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createMul(baseOffset++, dw, sourceRegister1, dw, sourceRegister2, qw, multiplicationResult));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, sourceRegister3, qw, multiplicationResult, qw, subtractionResult));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, subtractionResult, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "MLS");
        this.translateAll(environment, instruction, "MLS", instructions);
    }
}

