/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class THUMB2CbnzTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode labelOperand1 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        String sourceRegister1 = registerOperand1.getValue();
        String realJumpLabel = labelOperand1.getValue();
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String jmpGoal = String.format("%d.%d", instruction.getAddress().toLong(), 3);
        String jumpCondition = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBisz(baseOffset++, dw, sourceRegister1, dw, jumpCondition));
        instructions.add(ReilHelpers.createJcc(baseOffset++, dw, jumpCondition, dw, jmpGoal, new String[0]));
        instructions.add(ReilHelpers.createJcc(baseOffset++, dw, String.valueOf(1), dw, realJumpLabel, new String[0]));
        instructions.add(ReilHelpers.createNop(baseOffset++));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "CBNZ");
        this.translateAll(environment, instruction, "CBNZ", instructions);
    }
}

