/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class THUMB2BFITranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode immediateOperand1 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        IOperandTreeNode immediateOperand2 = instruction.getOperands().get(3).getRootNode().getChildren().get(0);
        String sourceRegister = registerOperand2.getValue();
        String destinationRegister = registerOperand1.getValue();
        String tempVar1 = environment.getNextVariableString();
        String tempVar2 = environment.getNextVariableString();
        String tempVar3 = environment.getNextVariableString();
        long oneMask = TranslationHelpers.generateOneMask(0, Integer.parseInt(immediateOperand2.getValue()), OperandSize.DWORD);
        long zeroMask = TranslationHelpers.generateZeroMask(Integer.parseInt(immediateOperand1.getValue()), Integer.parseInt(immediateOperand2.getValue()), OperandSize.DWORD);
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister, dw, String.valueOf(oneMask), dw, tempVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tempVar1, dw, immediateOperand1.getValue(), dw, tempVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, destinationRegister, dw, String.valueOf(zeroMask), dw, tempVar3));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tempVar2, dw, tempVar3, dw, destinationRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "BFI");
        this.translateAll(environment, instruction, "BFI", instructions);
    }
}

