/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class THUMB2BFCTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode immediateOperand1 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode immediateOperand2 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        long clearMask = TranslationHelpers.generateZeroMask(Integer.parseInt(immediateOperand1.getValue()), Integer.parseInt(immediateOperand2.getValue()), OperandSize.DWORD);
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, registerOperand.getValue(), dw, String.valueOf(clearMask), dw, registerOperand.getValue()));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "BFC");
        this.translateAll(environment, instruction, "BFC", instructions);
    }
}

