/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import java.util.ArrayList;
import java.util.List;

public abstract class Processor {
    private static final int REGISTER_SIZE = 32;
    protected static final OperandSize dw = OperandSize.DWORD;

    private static String[] extract(ITranslationEnvironment environment, String register2, int size, long offset, List<ReilInstruction> instructions) {
        assert (size == 8 || size == 16);
        long baseOffset = offset;
        ArrayList<String> results = new ArrayList<String>();
        for (int i2 = 0; i2 < 32 / size; ++i2) {
            String andResult = environment.getNextVariableString();
            String shiftResult = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, register2, dw, String.valueOf(Processor.getMask(i2, size)), dw, andResult));
            if (i2 != 0) {
                long l2 = baseOffset++;
                String string2 = String.valueOf(String.valueOf(i2 * size));
                instructions.add(ReilHelpers.createBsh(l2, dw, andResult, dw, string2.length() != 0 ? "-".concat(string2) : new String("-"), dw, shiftResult));
                results.add(shiftResult);
                continue;
            }
            results.add(andResult);
        }
        return results.toArray(new String[results.size()]);
    }

    private static int getMask(int bytePosition, int size) {
        return (size == 8 ? 255 : 65535) << bytePosition * size;
    }

    private static void merge(ITranslationEnvironment environment, long offset, int shiftDelta, String[] results, String targetRegister, int size, List<ReilInstruction> instructions) {
        assert (results.length == 2 || results.length == 4);
        long baseOffset = offset;
        String tempResult = environment.getNextVariableString();
        long mask = results.length == 2 ? 65535L : 255L;
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, String.valueOf(0L), dw, tempResult));
        if (shiftDelta != 0) {
            mask <<= 1;
        }
        int i2 = 0;
        for (String element : results) {
            String shiftResult = environment.getNextVariableString();
            String andResult = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, element, dw, String.valueOf(mask), dw, andResult));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, andResult, dw, String.valueOf(i2 * size + shiftDelta), dw, shiftResult));
            instructions.add(ReilHelpers.createOr(baseOffset++, dw, tempResult, dw, shiftResult, dw, tempResult));
            ++i2;
        }
        instructions.add(ReilHelpers.createStr(baseOffset, dw, tempResult, dw, targetRegister));
    }

    protected int getResultShiftDelta() {
        return 0;
    }

    protected abstract String[] process(long var1, String[] var3, String[] var4);

    public void generate(ITranslationEnvironment environment, long offset, int size, String sourceRegister1, String sourceRegister2, String targetRegister, List<ReilInstruction> instructions) {
        long baseOffset;
        long oldBaseOffset = baseOffset = offset;
        String[] firstExtracted = Processor.extract(environment, sourceRegister1, size, baseOffset, instructions);
        baseOffset = oldBaseOffset + (long)instructions.size();
        String[] secondExtracted = Processor.extract(environment, sourceRegister2, size, baseOffset, instructions);
        baseOffset = oldBaseOffset + (long)instructions.size();
        String[] results = this.process(baseOffset, firstExtracted, secondExtracted);
        baseOffset = oldBaseOffset + (long)instructions.size();
        assert (results.length == firstExtracted.length);
        Processor.merge(environment, baseOffset, this.getResultShiftDelta(), results, targetRegister, size, instructions);
    }
}

