/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public final class Helpers {
    private Helpers() {
    }

    private static Pair<String, String> generateSignMask(ITranslationEnvironment environment, long offset, String value, OperandSize size, List<ReilInstruction> instructions) {
        String msbMask = String.valueOf(TranslationHelpers.getMsbMask(size));
        String shiftValue = String.valueOf(TranslationHelpers.getShiftMsbLsbMask(size));
        String maskedMsb = environment.getNextVariableString();
        String msbInLsb = environment.getNextVariableString();
        String signMask = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(offset++, size, value, size, msbMask, size, maskedMsb));
        instructions.add(ReilHelpers.createBsh(offset++, size, maskedMsb, size, shiftValue, size, msbInLsb));
        instructions.add(ReilHelpers.createSub(offset++, size, "0", size, msbInLsb, size, signMask));
        return new Pair<String, String>(msbInLsb, signMask);
    }

    public static Pair<OperandSize, String> absValue(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String firstOperand, OperandSize size) throws InternalTranslationException {
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        long baseOffset = offset;
        String secondOperand = Helpers.shiftRightSigned(baseOffset, environment, instructions, size, firstOperand, -31);
        instructions.add(ReilHelpers.createAdd(baseOffset++, size, firstOperand, size, secondOperand, size, tmpVar1));
        instructions.add(ReilHelpers.createXor(baseOffset++, size, tmpVar1, size, secondOperand, size, tmpVar2));
        return new Pair<OperandSize, String>(size, tmpVar2);
    }

    public static void addOverflow(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, OperandSize firstOperandSize, String firstOperand, OperandSize secondOperandSize, String secondOperand, OperandSize resultOperandSize, String resultOperand, String overflow, long size) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(firstOperand, "Error: Argument firstOperand can't be null");
        Preconditions.checkNotNull(secondOperand, "Error: Argument secondOperand can't be null");
        Preconditions.checkNotNull(resultOperand, "Error: Argument resultOperand can't be null");
        Preconditions.checkArgument(size != 0L, "Error: Argument size can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        String msbVara = environment.getNextVariableString();
        String msbVarb = environment.getNextVariableString();
        String msbVarr = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String string2 = String.valueOf(String.valueOf(size - 1L));
        String shiftValue = string2.length() != 0 ? "-".concat(string2) : new String("-");
        long baseOffset = offset;
        instructions.add(ReilHelpers.createBsh(baseOffset++, firstOperandSize, firstOperand, wd, shiftValue, bt2, msbVara));
        instructions.add(ReilHelpers.createBsh(baseOffset++, secondOperandSize, secondOperand, wd, shiftValue, bt2, msbVarb));
        instructions.add(ReilHelpers.createBsh(baseOffset++, resultOperandSize, resultOperand, wd, shiftValue, bt2, msbVarr));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, msbVara, bt2, String.valueOf(1), bt2, msbVara));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, msbVarb, bt2, String.valueOf(1), bt2, msbVarb));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, msbVarr, bt2, String.valueOf(1), bt2, msbVarr));
        instructions.add(ReilHelpers.createXor(baseOffset++, bt2, msbVara, bt2, msbVarr, bt2, tmpVar4));
        instructions.add(ReilHelpers.createXor(baseOffset++, bt2, msbVarb, bt2, msbVarr, bt2, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar4, bt2, tmpVar3, bt2, overflow));
    }

    public static Pair<String, String> generateAbs(ITranslationEnvironment environment, long baseOffset, String value, OperandSize size, List<ReilInstruction> instructions) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(value, "Error: Argument value can't be null");
        Preconditions.checkNotNull(size, "Error: Argument size can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        int oldInstructionsSize = instructions.size();
        Pair<String, String> signMask = Helpers.generateSignMask(environment, baseOffset, value, size, instructions);
        long offset = baseOffset + (long)instructions.size() - (long)oldInstructionsSize;
        String toggledSign = environment.getNextVariableString();
        String absValue = environment.getNextVariableString();
        instructions.add(ReilHelpers.createXor(offset++, size, value, size, signMask.second(), size, toggledSign));
        instructions.add(ReilHelpers.createSub(offset++, size, toggledSign, size, signMask.second(), size, absValue));
        return new Pair<String, String>(signMask.first(), absValue);
    }

    public static String getCRM(int crm) {
        Long mask = 0L;
        for (int i2 = 0; i2 < 8; ++i2) {
            mask = mask << 4;
            if ((crm >> 7 - i2 & 1) != 1) continue;
            mask = mask | 0xFL;
        }
        return mask.toString();
    }

    public static int getCRRegisterIndex(String register2) {
        Integer retval = 0;
        try {
            retval = Integer.decode(register2);
        }
        catch (NumberFormatException e2) {
            String registerNumber = register2.substring(2);
            retval = Integer.decode(registerNumber);
        }
        return retval;
    }

    public static int getRegisterIndex(String register2) {
        if (register2.equals("SP")) {
            return 13;
        }
        if (register2.equals("LR")) {
            return 14;
        }
        if (register2.equals("PC")) {
            return 15;
        }
        return Integer.decode(register2.substring(1));
    }

    public static String getRotateMask(String maskMB, String maskME) {
        Long mask = 0L;
        int mb = Integer.decode(maskMB);
        int me = Integer.decode(maskME);
        if (mb == 0 && me == 31) {
            return String.valueOf(0xFFFFFFFFL);
        }
        int i2 = mb;
        while (i2 != (me + 1) % 32) {
            mask = mask | (mask >> 31 - i2 | 1L) << 31 - i2;
            i2 = (i2 + 1) % 32;
        }
        return mask.toString();
    }

    public static String highestNegativeValue(long bits) {
        return String.valueOf((1L << (int)bits ^ 0xFFFFFFFFL) + 1L);
    }

    public static String negBitMask(long bits) {
        return String.valueOf(0xFFFFFFFFL << (int)bits & 0xFFFFFFFFL);
    }

    public static void overflowCondition(long offset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String firstOperand) {
        OperandSize qw = OperandSize.QWORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize bt2 = OperandSize.BYTE;
        String isNotOverflowed = environment.getNextVariableString();
        String tmpVar7 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createBsh(baseOffset++, qw, firstOperand, dw, String.valueOf(-32), dw, tmpVar7));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dw, tmpVar7, bt2, isNotOverflowed));
        instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, isNotOverflowed, bt2, "Q"));
    }

    public static String posBitMask(long bits) {
        return String.valueOf(0xFFFFFFFFL << (int)bits & 0xFFFFFFFFL ^ 0xFFFFFFFFL);
    }

    public static String reverseUnsignedInteger(ITranslationEnvironment environment, long offset, String inputRegister, List<ReilInstruction> instructions) {
        long baseOffset = offset;
        OperandSize dw = OperandSize.DWORD;
        String tempVar10 = environment.getNextVariableString();
        String tempVar11 = environment.getNextVariableString();
        String tempVar12 = environment.getNextVariableString();
        String tempVar13 = environment.getNextVariableString();
        String tempVar1x = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, inputRegister, dw, String.valueOf(0x55555555L), dw, tempVar10));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tempVar10, dw, String.valueOf(1L), dw, tempVar11));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, inputRegister, dw, String.valueOf(-1L), dw, tempVar12));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tempVar12, dw, String.valueOf(0x55555555L), dw, tempVar13));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tempVar11, dw, tempVar13, dw, tempVar1x));
        String tempVar20 = environment.getNextVariableString();
        String tempVar21 = environment.getNextVariableString();
        String tempVar22 = environment.getNextVariableString();
        String tempVar23 = environment.getNextVariableString();
        String tempVar2x = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tempVar1x, dw, String.valueOf(0x33333333L), dw, tempVar20));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tempVar20, dw, String.valueOf(2L), dw, tempVar21));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tempVar1x, dw, String.valueOf(-2L), dw, tempVar22));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tempVar22, dw, String.valueOf(0x33333333L), dw, tempVar23));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tempVar21, dw, tempVar23, dw, tempVar2x));
        String tempVar30 = environment.getNextVariableString();
        String tempVar31 = environment.getNextVariableString();
        String tempVar32 = environment.getNextVariableString();
        String tempVar33 = environment.getNextVariableString();
        String tempVar3x = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tempVar2x, dw, String.valueOf(0xF0F0F0FL), dw, tempVar30));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tempVar30, dw, String.valueOf(4L), dw, tempVar31));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tempVar2x, dw, String.valueOf(-4L), dw, tempVar32));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tempVar32, dw, String.valueOf(0xF0F0F0FL), dw, tempVar33));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tempVar31, dw, tempVar33, dw, tempVar3x));
        String tempVar40 = environment.getNextVariableString();
        String tempVar41 = environment.getNextVariableString();
        String tempVar42 = environment.getNextVariableString();
        String tempVar4x = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tempVar3x, dw, String.valueOf(24), dw, tempVar40));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tempVar3x, dw, String.valueOf(65280L), dw, tempVar41));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tempVar41, dw, String.valueOf(8L), dw, tempVar42));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tempVar42, dw, tempVar40, dw, tempVar4x));
        String tempVar50 = environment.getNextVariableString();
        String tempVar51 = environment.getNextVariableString();
        String tempVar52 = environment.getNextVariableString();
        String tempVar5x = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tempVar3x, dw, String.valueOf(-8L), dw, tempVar50));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tempVar50, dw, String.valueOf(65280L), dw, tempVar51));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tempVar3x, dw, String.valueOf(-24L), dw, tempVar52));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tempVar51, dw, tempVar52, dw, tempVar5x));
        String result = environment.getNextVariableString();
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tempVar4x, dw, tempVar5x, dw, result));
        return result;
    }

    public static String shiftRightSigned(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, OperandSize size, String operandValue, int shiftValue) throws InternalTranslationException {
        if (shiftValue > 0) {
            throw new InternalTranslationException("right shift needs negative shiftvalue");
        }
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createAdd(baseOffset++, size, operandValue, size, String.valueOf(0x80000000L), size, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, size, tmpVar1, size, String.valueOf(shiftValue), size, tmpVar2));
        instructions.add(ReilHelpers.createBsh(baseOffset++, size, String.valueOf(0x80000000L), size, String.valueOf(shiftValue), size, tmpVar3));
        instructions.add(ReilHelpers.createSub(baseOffset++, size, tmpVar2, size, tmpVar3, size, tmpVar4));
        return tmpVar4;
    }

    public static void signedMul(long offset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, OperandSize firstOperandSize, String firstOperand, OperandSize secondOperandSize, String secondOperand, OperandSize resultOperandSize, String resultOperand) {
        String xoredResult = environment.getNextVariableString();
        String multResult = environment.getNextVariableString();
        String toggleMask = environment.getNextVariableString();
        String xoredSigns = environment.getNextVariableString();
        long baseOffset = offset;
        Pair<String, String> abs1 = Helpers.generateAbs(environment, baseOffset, firstOperand, firstOperandSize, instructions);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Pair<String, String> abs2 = Helpers.generateAbs(environment, baseOffset, secondOperand, secondOperandSize, instructions);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String firstAbs = abs1.second();
        String secondAbs = abs2.second();
        instructions.add(ReilHelpers.createMul(baseOffset++, firstOperandSize, firstAbs, secondOperandSize, secondAbs, resultOperandSize, multResult));
        instructions.add(ReilHelpers.createXor(baseOffset++, firstOperandSize, abs1.first(), secondOperandSize, abs2.first(), firstOperandSize, xoredSigns));
        instructions.add(ReilHelpers.createSub(baseOffset++, firstOperandSize, "0", firstOperandSize, xoredSigns, resultOperandSize, toggleMask));
        instructions.add(ReilHelpers.createXor(baseOffset++, resultOperandSize, toggleMask, resultOperandSize, multResult, resultOperandSize, xoredResult));
        instructions.add(ReilHelpers.createAdd(baseOffset++, resultOperandSize, xoredResult, firstOperandSize, xoredSigns, resultOperandSize, resultOperand));
    }

    public static void signedSat(long offset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, OperandSize firstOperandSize, String firstOperand, OperandSize secondOperandSize, String secondOperand, OperandSize resultOperandSize, String resultOperand, String operation, String tmpResultVar, long size, String signedDoesSat) {
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        String signedSatMaskLess = Helpers.posBitMask(size - 1L);
        String lowSatResult = Helpers.highestNegativeValue(size - 1L);
        String highSatResult = signedSatMaskLess;
        String inRange = environment.getNextVariableString();
        String inRangeMask = environment.getNextVariableString();
        String isGreaterCondition = environment.getNextVariableString();
        String isGreaterMask = environment.getNextVariableString();
        String isLessCondition = environment.getNextVariableString();
        String isLessMask = environment.getNextVariableString();
        String tmpLowResult1 = environment.getNextVariableString();
        String tmpLowResult2 = environment.getNextVariableString();
        String tmpLowResult3 = environment.getNextVariableString();
        String tmpLowResult4 = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String overflow = environment.getNextVariableString();
        String isNegative = environment.getNextVariableString();
        String isPositive = environment.getNextVariableString();
        long baseOffset = offset;
        String addOperation = "ADD";
        if (operation.equalsIgnoreCase("ADD") || operation.equalsIgnoreCase("SUB")) {
            if (operation.equalsIgnoreCase("ADD")) {
                Helpers.addOverflow(baseOffset, environment, instructions, firstOperandSize, firstOperand, secondOperandSize, secondOperand, resultOperandSize, resultOperand, overflow, size);
            } else if (operation.equalsIgnoreCase("SUB")) {
                Helpers.subOverflow(baseOffset, environment, instruction, instructions, firstOperandSize, firstOperand, secondOperandSize, secondOperand, resultOperandSize, resultOperand, overflow, size);
            }
            long l2 = baseOffset++;
            String string2 = String.valueOf(String.valueOf(size - 1L));
            instructions.add(ReilHelpers.createBsh(l2, dw, resultOperand, dw, string2.length() != 0 ? "-".concat(string2) : new String("-"), bt2, tmpVar1));
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar1, bt2, String.valueOf(1L), bt2, isNegative));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, isNegative, bt2, isPositive));
            ++baseOffset;
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, isPositive, bt2, overflow, bt2, isLessCondition));
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, isNegative, bt2, overflow, bt2, isGreaterCondition));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, overflow, bt2, inRange));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, isLessCondition, dw, isLessMask));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, isGreaterCondition, dw, isGreaterMask));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, inRange, dw, inRangeMask));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, resultOperand, dw, inRangeMask, dw, tmpLowResult1));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, lowSatResult, dw, isLessMask, dw, tmpLowResult2));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, highSatResult, dw, isGreaterMask, dw, tmpLowResult3));
            instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpLowResult1, dw, tmpLowResult2, dw, tmpLowResult4));
            instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpLowResult4, dw, tmpLowResult3, dw, tmpResultVar));
        } else {
            String needsShiftCompare = environment.getNextVariableString();
            String xMinusy = environment.getNextVariableString();
            String xMinusyXorx = environment.getNextVariableString();
            String xXory = environment.getNextVariableString();
            String xXoryAndxMinusXorx = environment.getNextVariableString();
            String lowOverflow = environment.getNextVariableString();
            String highOverflow = environment.getNextVariableString();
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, firstOperand, dw, lowSatResult, dw, xMinusy));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, firstOperand, dw, lowSatResult, dw, xXory));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, xMinusy, dw, firstOperand, dw, xMinusyXorx));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, xXory, dw, xMinusyXorx, dw, xXoryAndxMinusXorx));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, xMinusy, dw, xXoryAndxMinusXorx, dw, needsShiftCompare));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, needsShiftCompare, dw, String.valueOf(-31L), bt2, lowOverflow));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, highSatResult, dw, firstOperand, dw, xMinusy));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, highSatResult, dw, firstOperand, dw, xXory));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, xMinusy, dw, highSatResult, dw, xMinusyXorx));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, xXory, dw, xMinusyXorx, dw, xXoryAndxMinusXorx));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, xMinusy, dw, xXoryAndxMinusXorx, dw, needsShiftCompare));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, needsShiftCompare, dw, String.valueOf(-31L), bt2, highOverflow));
            instructions.add(ReilHelpers.createOr(baseOffset++, bt2, lowOverflow, bt2, highOverflow, bt2, overflow));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, overflow, bt2, inRange));
            if (operation.equalsIgnoreCase("SSAT")) {
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, lowOverflow, dw, isLessMask));
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, highOverflow, dw, isGreaterMask));
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, inRange, dw, inRangeMask));
            } else {
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, highOverflow, dw, isLessMask));
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, lowOverflow, dw, isGreaterMask));
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, inRange, dw, inRangeMask));
            }
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, resultOperand, dw, inRangeMask, dw, tmpLowResult1));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, lowSatResult, dw, isLessMask, dw, tmpLowResult2));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, highSatResult, dw, isGreaterMask, dw, tmpLowResult3));
            instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpLowResult1, dw, tmpLowResult2, dw, tmpLowResult4));
            instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpLowResult4, dw, tmpLowResult3, dw, tmpResultVar));
        }
    }

    public static void signedSub(long offset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String firstOperand, String secondOperand, String resultOperand, String trueResult) {
        String tmpResult = environment.getNextVariableString();
        String twoComplementfirstOperand = environment.getNextVariableString();
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        OperandSize bt2 = OperandSize.BYTE;
        long baseOffset = offset;
        instructions.add(ReilHelpers.createXor(baseOffset++, dw, firstOperand, dw, String.valueOf(0xFFFFFFFFL), dw, twoComplementfirstOperand));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, twoComplementfirstOperand, dw, secondOperand, qw, tmpResult));
        instructions.add(ReilHelpers.createAdd(baseOffset++, qw, tmpResult, bt2, String.valueOf(1L), qw, trueResult));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, trueResult, dw, String.valueOf(0xFFFFFFFFL), dw, resultOperand));
    }

    public static void signExtend(long offset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, OperandSize firstOperandSize, String firstOperand, OperandSize resultOperandSize, String resultOperand, int size) {
        OperandSize dw = OperandSize.DWORD;
        String fMask = "";
        String eightMask = "";
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        if (size == 8) {
            fMask = String.valueOf(255L);
            eightMask = String.valueOf(128L);
        } else if (size == 16) {
            fMask = String.valueOf(65535L);
            eightMask = String.valueOf(32768L);
        } else {
            fMask = String.valueOf(0xFFFFFFFFL);
            eightMask = String.valueOf(0x80000000L);
        }
        long baseOffset = offset;
        instructions.add(ReilHelpers.createAdd(baseOffset++, firstOperandSize, firstOperand, dw, eightMask, dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, fMask, dw, tmpVar2));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpVar2, dw, eightMask, resultOperandSize, resultOperand));
    }

    public static void subOverflow(long offset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, OperandSize firstOperandSize, String firstOperand, OperandSize secondOperandSize, String secondOperand, OperandSize resultOperandSize, String resultOperand, String overflow, long size) {
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        String msbVara = environment.getNextVariableString();
        String msbVarb = environment.getNextVariableString();
        String msbVarr = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String string2 = String.valueOf(String.valueOf(size - 1L));
        String shiftVal = string2.length() != 0 ? "-".concat(string2) : new String("-");
        long baseOffset = offset;
        instructions.add(ReilHelpers.createBsh(baseOffset++, firstOperandSize, firstOperand, wd, shiftVal, bt2, msbVara));
        instructions.add(ReilHelpers.createBsh(baseOffset++, secondOperandSize, secondOperand, wd, shiftVal, bt2, msbVarb));
        instructions.add(ReilHelpers.createBsh(baseOffset++, resultOperandSize, resultOperand, wd, shiftVal, bt2, msbVarr));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, msbVara, bt2, String.valueOf(1), bt2, msbVara));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, msbVarb, bt2, String.valueOf(1), bt2, msbVarb));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, msbVarr, bt2, String.valueOf(1), bt2, msbVarr));
        instructions.add(ReilHelpers.createXor(baseOffset++, bt2, msbVara, bt2, msbVarb, bt2, tmpVar4));
        instructions.add(ReilHelpers.createXor(baseOffset++, bt2, msbVara, bt2, msbVarr, bt2, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar4, bt2, tmpVar3, bt2, overflow));
    }

    public static void unsignedCompareXSmallerY(long offset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, OperandSize xOperandSize, String xOperand, OperandSize yOperandSize, String yOperand, OperandSize isSmallerSize, String isSmaller) {
        OperandSize dw = OperandSize.DWORD;
        String notXandYOperand = environment.getNextVariableString();
        String notXOperand = environment.getNextVariableString();
        String notXorYOperand = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String xMinusYOperand = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createXor(baseOffset++, xOperandSize, xOperand, dw, String.valueOf(0xFFFFFFFFL), dw, notXOperand));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, notXOperand, yOperandSize, yOperand, dw, notXandYOperand));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, notXOperand, yOperandSize, yOperand, dw, notXorYOperand));
        instructions.add(ReilHelpers.createSub(baseOffset++, xOperandSize, xOperand, yOperandSize, yOperand, dw, xMinusYOperand));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, notXorYOperand, dw, xMinusYOperand, dw, tmpVar1));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, notXandYOperand, dw, tmpVar1, isSmallerSize, isSmaller));
        instructions.add(ReilHelpers.createBsh(baseOffset++, isSmallerSize, isSmaller, dw, String.valueOf(-31L), isSmallerSize, isSmaller));
    }

    public static void unsignedSat(long offset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String firstOperand, String secondOperand, String resultOperand, String operation, String tmpResultVar, long size, String signedDoesSat) {
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        String lowSatResult = String.valueOf(0);
        String highSatResult = String.valueOf((long)Math.pow(2.0, size) - 1L);
        String inRange = environment.getNextVariableString();
        String inRangeMask = environment.getNextVariableString();
        String isGreaterCondition = environment.getNextVariableString();
        String isGreaterMask = environment.getNextVariableString();
        String isLessCondition = environment.getNextVariableString();
        String isLessMask = environment.getNextVariableString();
        String tmpLowResult1 = environment.getNextVariableString();
        String tmpLowResult2 = environment.getNextVariableString();
        String tmpLowResult3 = environment.getNextVariableString();
        String tmpLowResult4 = environment.getNextVariableString();
        String overflow = environment.getNextVariableString();
        String isNegative = environment.getNextVariableString();
        String isPositive = environment.getNextVariableString();
        long baseOffset = offset;
        String addOperation = "ADD";
        if (operation.equalsIgnoreCase("ADD") || operation.equalsIgnoreCase("SUB")) {
            long l2 = baseOffset++;
            String string2 = String.valueOf(String.valueOf(size));
            instructions.add(ReilHelpers.createBsh(l2, dw, resultOperand, dw, string2.length() != 0 ? "-".concat(string2) : new String("-"), bt2, overflow));
            if (operation.equalsIgnoreCase("ADD")) {
                instructions.add(ReilHelpers.createStr(baseOffset++, bt2, String.valueOf(1L), bt2, isPositive));
                instructions.add(ReilHelpers.createStr(baseOffset++, bt2, String.valueOf(0L), bt2, isNegative));
            } else {
                instructions.add(ReilHelpers.createStr(baseOffset++, bt2, String.valueOf(0L), bt2, isPositive));
                instructions.add(ReilHelpers.createStr(baseOffset++, bt2, String.valueOf(1L), bt2, isNegative));
            }
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, isNegative, bt2, overflow, bt2, isLessCondition));
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, isPositive, bt2, overflow, bt2, isGreaterCondition));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, overflow, bt2, inRange));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, isLessCondition, dw, isLessMask));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, isGreaterCondition, dw, isGreaterMask));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, inRange, dw, inRangeMask));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, resultOperand, dw, inRangeMask, dw, tmpLowResult1));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, lowSatResult, dw, isLessMask, dw, tmpLowResult2));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, highSatResult, dw, isGreaterMask, dw, tmpLowResult3));
            instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpLowResult1, dw, tmpLowResult2, dw, tmpLowResult4));
            instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpLowResult4, dw, tmpLowResult3, dw, tmpResultVar));
        } else {
            String needsShiftCompare = environment.getNextVariableString();
            String xMinusy = environment.getNextVariableString();
            String xMinusyXorx = environment.getNextVariableString();
            String xXory = environment.getNextVariableString();
            String xXoryAndxMinusXorx = environment.getNextVariableString();
            String lowOverflow = environment.getNextVariableString();
            String highOverflow = environment.getNextVariableString();
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, firstOperand, dw, lowSatResult, dw, xMinusy));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, firstOperand, dw, lowSatResult, dw, xXory));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, xMinusy, dw, firstOperand, dw, xMinusyXorx));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, xXory, dw, xMinusyXorx, dw, xXoryAndxMinusXorx));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, xMinusy, dw, xXoryAndxMinusXorx, dw, needsShiftCompare));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, needsShiftCompare, dw, String.valueOf(-31L), bt2, lowOverflow));
            ++baseOffset;
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, highSatResult, dw, firstOperand, dw, xMinusy));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, highSatResult, dw, firstOperand, dw, xXory));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, xMinusy, dw, highSatResult, dw, xMinusyXorx));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, xXory, dw, xMinusyXorx, dw, xXoryAndxMinusXorx));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, xMinusy, dw, xXoryAndxMinusXorx, dw, needsShiftCompare));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, needsShiftCompare, dw, String.valueOf(-31L), bt2, highOverflow));
            instructions.add(ReilHelpers.createOr(baseOffset++, bt2, lowOverflow, bt2, highOverflow, bt2, overflow));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, overflow, bt2, inRange));
            if (operation.equalsIgnoreCase("USAT")) {
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, lowOverflow, dw, isLessMask));
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, highOverflow, dw, isGreaterMask));
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, inRange, dw, inRangeMask));
            } else {
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, highOverflow, dw, isLessMask));
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, lowOverflow, dw, isGreaterMask));
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0), bt2, inRange, dw, inRangeMask));
            }
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, resultOperand, dw, inRangeMask, dw, tmpLowResult1));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, lowSatResult, dw, isLessMask, dw, tmpLowResult2));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, highSatResult, dw, isGreaterMask, dw, tmpLowResult3));
            instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpLowResult1, dw, tmpLowResult2, dw, tmpLowResult4));
            instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpLowResult4, dw, tmpLowResult3, dw, tmpResultVar));
        }
    }
}

