/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public final class ConditionGenerator {
    private ConditionGenerator() {
    }

    public static void generate(long offset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String extension2, String jumpGoal) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instruction, "Error: Argument instruction can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        OperandSize bt2 = OperandSize.BYTE;
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String jumpCondition = environment.getNextVariableString();
        long baseOffset = offset;
        String[] meta = new String[]{};
        if (extension2.compareTo("EQ") == 0) {
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, "Z", bt2, jumpCondition));
        } else if (extension2.compareTo("NE") == 0) {
            instructions.add(ReilHelpers.createStr(baseOffset++, bt2, "Z", bt2, jumpCondition));
        } else if (extension2.compareTo("CS") == 0 || extension2.compareTo("HS") == 0) {
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, "C", bt2, jumpCondition));
        } else if (extension2.compareTo("CC") == 0 || extension2.compareTo("LO") == 0) {
            instructions.add(ReilHelpers.createStr(baseOffset++, bt2, "C", bt2, jumpCondition));
        } else if (extension2.compareTo("MI") == 0) {
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, "N", bt2, jumpCondition));
        } else if (extension2.compareTo("PL") == 0) {
            instructions.add(ReilHelpers.createStr(baseOffset++, bt2, "N", bt2, jumpCondition));
        } else if (extension2.compareTo("VS") == 0) {
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, "V", bt2, jumpCondition));
        } else if (extension2.compareTo("VC") == 0) {
            instructions.add(ReilHelpers.createStr(baseOffset++, bt2, "V", bt2, jumpCondition));
        } else if (extension2.compareTo("HI") == 0) {
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, "C", bt2, tmpVar1));
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar1, bt2, "Z", bt2, jumpCondition));
        } else if (extension2.compareTo("LS") == 0) {
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, "Z", bt2, tmpVar1));
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar1, bt2, "C", bt2, jumpCondition));
        } else if (extension2.compareTo("GE") == 0) {
            instructions.add(ReilHelpers.createXor(baseOffset++, bt2, "N", bt2, "V", bt2, tmpVar1));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, tmpVar1, bt2, jumpCondition));
        } else if (extension2.compareTo("LT") == 0) {
            instructions.add(ReilHelpers.createXor(baseOffset++, bt2, "N", bt2, "V", bt2, tmpVar1));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, tmpVar1, bt2, jumpCondition));
        } else if (extension2.compareTo("GT") == 0) {
            instructions.add(ReilHelpers.createXor(baseOffset++, bt2, "N", bt2, "V", bt2, tmpVar1));
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar1, bt2, "Z", bt2, jumpCondition));
        } else if (extension2.compareTo("LE") == 0) {
            instructions.add(ReilHelpers.createXor(baseOffset++, bt2, "N", bt2, "V", bt2, tmpVar1));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, tmpVar1, bt2, tmpVar3));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, "Z", bt2, tmpVar2));
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar3, bt2, tmpVar2, bt2, jumpCondition));
        } else if (extension2.compareTo("AL") == 0) {
            instructions.add(ReilHelpers.createStr(baseOffset++, bt2, String.valueOf(0L), bt2, jumpCondition));
        } else if (extension2.compareTo("NV") == 0) {
            instructions.add(ReilHelpers.createStr(baseOffset++, bt2, String.valueOf(1L), bt2, jumpCondition));
        } else {
            String string2 = String.valueOf(extension2);
            throw new InternalTranslationException(string2.length() != 0 ? "ERROR: unknown condition ".concat(string2) : new String("ERROR: unknown condition "));
        }
        instructions.add(ReilHelpers.createJcc(baseOffset++, bt2, jumpCondition, OperandSize.ADDRESS, jumpGoal, meta));
    }
}

