/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public final class AddressingModeTwoGenerator {
    static final OperandSize bt = OperandSize.BYTE;
    static final OperandSize wd = OperandSize.WORD;
    static final OperandSize dw = OperandSize.DWORD;
    static final OperandSize qw = OperandSize.QWORD;
    private static String dWordBitMask = String.valueOf(0xFFFFFFFFL);

    private AddressingModeTwoGenerator() {
    }

    private static Pair<String, String> offsetASR(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        String tmpVar = environment.getNextVariableString();
        long baseOffset = offset;
        if (immediateNodeValue.equals("0")) {
            String isZeroCondition = environment.getNextVariableString();
            String tmpVar1 = environment.getNextVariableString();
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, registerNodeValue2, wd, String.valueOf(-31), dw, tmpVar1));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, tmpVar1, bt, isZeroCondition));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0L), bt, isZeroCondition, dw, index));
        } else {
            String tmpVar1 = environment.getNextVariableString();
            String tmpVar2 = environment.getNextVariableString();
            String tmpVar3 = environment.getNextVariableString();
            String tmpVar4 = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue2, dw, String.valueOf(0x80000000L), dw, tmpVar1));
            long l2 = baseOffset++;
            String string2 = String.valueOf(immediateNodeValue);
            instructions.add(ReilHelpers.createBsh(l2, dw, tmpVar1, dw, string2.length() != 0 ? "-".concat(string2) : new String("-"), dw, tmpVar2));
            long l3 = baseOffset++;
            String string3 = String.valueOf(immediateNodeValue);
            instructions.add(ReilHelpers.createBsh(l3, dw, String.valueOf(0x80000000L), dw, string3.length() != 0 ? "-".concat(string3) : new String("-"), dw, tmpVar3));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpVar2, dw, tmpVar3, qw, tmpVar4));
            instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar4, dw, dWordBitMask, dw, index));
        }
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar, dw, dWordBitMask, dw, address));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> offsetImm(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue, dw, immediateNodeValue, dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, dWordBitMask, dw, address));
        return new Pair<String, String>(address, registerNodeValue);
    }

    private static Pair<String, String> offsetLSL(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, registerNodeValue2, dw, immediateNodeValue, qw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar1, dw, dWordBitMask, dw, index));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar2, dw, dWordBitMask, dw, address));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> offsetLSR(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        long baseOffset = offset;
        long l2 = baseOffset++;
        String string2 = String.valueOf(immediateNodeValue);
        instructions.add(ReilHelpers.createBsh(l2, dw, registerNodeValue2, dw, string2.length() != 0 ? "-".concat(string2) : new String("-"), qw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar1, dw, dWordBitMask, dw, index));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar2, dw, dWordBitMask, dw, address));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> offsetReg(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2) {
        String address = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, registerNodeValue2, dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, dWordBitMask, dw, address));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> offsetROR(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        String tmpVar = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        long baseOffset = offset;
        long l2 = baseOffset++;
        String string2 = String.valueOf(Integer.decode(immediateNodeValue));
        instructions.add(ReilHelpers.createBsh(l2, dw, registerNodeValue2, dw, new StringBuilder(1 + String.valueOf(string2).length()).append("-").append(string2).toString(), dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, registerNodeValue2, dw, String.valueOf(32 - Integer.decode(immediateNodeValue)), dw, tmpVar2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpVar1, dw, tmpVar2, dw, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar3, dw, dWordBitMask, dw, index));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar, dw, dWordBitMask, dw, address));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> offsetRRX(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2) {
        String address = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        String tmpVar = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createBsh(baseOffset++, bt, "C", wd, String.valueOf(31), dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, registerNodeValue2, bt, String.valueOf(-1), dw, tmpVar2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpVar1, dw, tmpVar2, dw, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar3, dw, dWordBitMask, dw, index));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar, dw, dWordBitMask, dw, address));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> postIndexedASR(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        String tmpVar = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, registerNodeValue1, dw, address));
        if (immediateNodeValue.equals("0")) {
            String isZeroCondition = environment.getNextVariableString();
            String tmpVar1 = environment.getNextVariableString();
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, registerNodeValue2, wd, String.valueOf(-31), dw, tmpVar1));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, tmpVar1, bt, isZeroCondition));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0L), bt, isZeroCondition, dw, index));
        } else {
            String tmpVar1 = environment.getNextVariableString();
            String tmpVar2 = environment.getNextVariableString();
            String tmpVar3 = environment.getNextVariableString();
            String tmpVar4 = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue2, dw, String.valueOf(0x80000000L), dw, tmpVar1));
            long l2 = baseOffset++;
            String string2 = String.valueOf(immediateNodeValue);
            instructions.add(ReilHelpers.createBsh(l2, dw, tmpVar1, dw, string2.length() != 0 ? "-".concat(string2) : new String("-"), dw, tmpVar2));
            long l3 = baseOffset++;
            String string3 = String.valueOf(immediateNodeValue);
            instructions.add(ReilHelpers.createBsh(l3, dw, String.valueOf(0x80000000L), dw, string3.length() != 0 ? "-".concat(string3) : new String("-"), dw, tmpVar3));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpVar2, dw, tmpVar3, qw, tmpVar4));
            instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar4, dw, dWordBitMask, dw, index));
        }
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar, dw, dWordBitMask, dw, registerNodeValue1));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> postIndexedImm(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, registerNodeValue, dw, address));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue, dw, immediateNodeValue, dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, dWordBitMask, dw, registerNodeValue));
        return new Pair<String, String>(address, registerNodeValue);
    }

    private static Pair<String, String> postIndexedLSL(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, registerNodeValue1, dw, address));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, registerNodeValue2, dw, immediateNodeValue, qw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar1, dw, dWordBitMask, dw, index));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar2, dw, dWordBitMask, dw, registerNodeValue1));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> postIndexedLSR(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, registerNodeValue1, dw, address));
        long l2 = baseOffset++;
        String string2 = String.valueOf(immediateNodeValue);
        instructions.add(ReilHelpers.createBsh(l2, dw, registerNodeValue2, dw, string2.length() != 0 ? "-".concat(string2) : new String("-"), qw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar1, dw, dWordBitMask, dw, index));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar2, dw, dWordBitMask, dw, registerNodeValue1));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> postIndexedReg(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2) {
        String address = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, registerNodeValue1, dw, address));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, registerNodeValue2, dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, dWordBitMask, dw, registerNodeValue1));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> postIndexedROR(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        String tmpVar = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, registerNodeValue1, dw, address));
        long l2 = baseOffset++;
        String string2 = String.valueOf(Integer.decode(immediateNodeValue));
        instructions.add(ReilHelpers.createBsh(l2, dw, registerNodeValue2, dw, new StringBuilder(1 + String.valueOf(string2).length()).append("-").append(string2).toString(), dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, registerNodeValue2, dw, String.valueOf(32 - Integer.decode(immediateNodeValue)), dw, tmpVar2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpVar1, dw, tmpVar2, dw, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar3, dw, dWordBitMask, dw, index));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar, dw, dWordBitMask, dw, registerNodeValue1));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> postIndexedRRX(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2) {
        String address = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        String tmpVar = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, registerNodeValue1, dw, address));
        instructions.add(ReilHelpers.createBsh(baseOffset++, bt, "C", wd, String.valueOf(31), dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, registerNodeValue2, bt, String.valueOf(-1), dw, tmpVar2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpVar1, dw, tmpVar2, dw, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar3, dw, dWordBitMask, dw, index));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar, dw, dWordBitMask, dw, registerNodeValue1));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> preIndexedASR(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        String tmpVar = environment.getNextVariableString();
        long baseOffset = offset;
        if (immediateNodeValue.equals("0")) {
            String isZeroCondition = environment.getNextVariableString();
            String tmpVar1 = environment.getNextVariableString();
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, registerNodeValue2, wd, String.valueOf(-31), dw, tmpVar1));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, tmpVar1, bt, isZeroCondition));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, String.valueOf(0L), bt, isZeroCondition, dw, index));
        } else {
            String tmpVar1 = environment.getNextVariableString();
            String tmpVar2 = environment.getNextVariableString();
            String tmpVar3 = environment.getNextVariableString();
            String tmpVar4 = environment.getNextVariableString();
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue2, dw, String.valueOf(0x80000000L), dw, tmpVar1));
            long l2 = baseOffset++;
            String string2 = String.valueOf(immediateNodeValue);
            instructions.add(ReilHelpers.createBsh(l2, dw, tmpVar1, dw, string2.length() != 0 ? "-".concat(string2) : new String("-"), dw, tmpVar2));
            long l3 = baseOffset++;
            String string3 = String.valueOf(immediateNodeValue);
            instructions.add(ReilHelpers.createBsh(l3, dw, String.valueOf(0x80000000L), dw, string3.length() != 0 ? "-".concat(string3) : new String("-"), dw, tmpVar3));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpVar2, dw, tmpVar3, qw, tmpVar4));
            instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar4, dw, dWordBitMask, dw, index));
        }
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar, dw, dWordBitMask, dw, address));
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, address, dw, registerNodeValue1));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> preIndexedImm(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue, dw, immediateNodeValue, dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, dWordBitMask, dw, address));
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, address, dw, registerNodeValue));
        return new Pair<String, String>(address, registerNodeValue);
    }

    private static Pair<String, String> preIndexedLSL(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, registerNodeValue2, dw, immediateNodeValue, qw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar1, dw, dWordBitMask, dw, index));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar2, dw, dWordBitMask, dw, address));
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, address, dw, registerNodeValue1));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> preIndexedLSR(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        long baseOffset = offset;
        long l2 = baseOffset++;
        String string2 = String.valueOf(immediateNodeValue);
        instructions.add(ReilHelpers.createBsh(l2, dw, registerNodeValue2, dw, string2.length() != 0 ? "-".concat(string2) : new String("-"), qw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar1, dw, dWordBitMask, dw, index));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar2, dw, dWordBitMask, dw, address));
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, address, dw, registerNodeValue1));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> preIndexedReg(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2) {
        String address = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, registerNodeValue2, dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, dWordBitMask, dw, address));
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, address, dw, registerNodeValue1));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> preIndexedROR(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2, String immediateNodeValue) {
        String address = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        String tmpVar = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        long baseOffset = offset;
        long l2 = baseOffset++;
        String string2 = String.valueOf(Integer.decode(immediateNodeValue));
        instructions.add(ReilHelpers.createBsh(l2, dw, registerNodeValue2, dw, new StringBuilder(1 + String.valueOf(string2).length()).append("-").append(string2).toString(), dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, registerNodeValue2, dw, String.valueOf(32 - Integer.decode(immediateNodeValue)), dw, tmpVar2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpVar1, dw, tmpVar2, dw, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar3, dw, dWordBitMask, dw, index));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar, dw, dWordBitMask, dw, address));
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, address, dw, registerNodeValue1));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    private static Pair<String, String> preIndexedRRX(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2) {
        String address = environment.getNextVariableString();
        String index = environment.getNextVariableString();
        String tmpVar = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createBsh(baseOffset++, bt, "C", wd, String.valueOf(31), dw, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, registerNodeValue2, bt, String.valueOf(-1), dw, tmpVar2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpVar1, dw, tmpVar2, dw, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar3, dw, dWordBitMask, dw, index));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue1, dw, index, dw, tmpVar));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar, dw, dWordBitMask, dw, address));
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, address, dw, registerNodeValue1));
        return new Pair<String, String>(address, registerNodeValue1);
    }

    public static Pair<String, String> generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, IOperandTreeNode rootNode) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instruction, "Error: Argument instruction can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        if (rootNode.getChildren().get(0).getValue().equals("!")) {
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER && rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getType() == ExpressionType.IMMEDIATE_INTEGER) {
                return AddressingModeTwoGenerator.preIndexedImm(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER && rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getType() == ExpressionType.REGISTER) {
                return AddressingModeTwoGenerator.preIndexedReg(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getValue().equals("LSL")) {
                return AddressingModeTwoGenerator.preIndexedLSL(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getValue().equals("LSR")) {
                return AddressingModeTwoGenerator.preIndexedLSR(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getValue().equals("ASR")) {
                return AddressingModeTwoGenerator.preIndexedASR(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getValue().equals("ROR")) {
                return AddressingModeTwoGenerator.preIndexedROR(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getValue().equals("RRX")) {
                return AddressingModeTwoGenerator.preIndexedRRX(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue());
            }
            throw new InternalTranslationException("Error: AddressOperandTypeTwo preIndexed shifter is not valid");
        }
        if (rootNode.getChildren().get(0).getValue().equals(",")) {
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER && rootNode.getChildren().get(0).getChildren().get(1).getType() == ExpressionType.IMMEDIATE_INTEGER) {
                return AddressingModeTwoGenerator.postIndexedImm(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER && rootNode.getChildren().get(0).getChildren().get(1).getType() == ExpressionType.REGISTER) {
                return AddressingModeTwoGenerator.postIndexedReg(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(1).getValue().equals("LSL")) {
                return AddressingModeTwoGenerator.postIndexedLSL(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(1).getValue().equals("LSR")) {
                return AddressingModeTwoGenerator.postIndexedLSR(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(1).getValue().equals("ASR")) {
                return AddressingModeTwoGenerator.postIndexedASR(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(1).getValue().equals("ROR")) {
                return AddressingModeTwoGenerator.postIndexedROR(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(1).getValue().equals("RRX")) {
                return AddressingModeTwoGenerator.postIndexedRRX(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue());
            }
            throw new InternalTranslationException("Error: AddressOperandTypeTwo postIndexed shifter is not valid");
        }
        if (rootNode.getChildren().get(0).getValue().equals("[")) {
            if (rootNode.getChildren().get(0).getChildren().get(0).getType() == ExpressionType.IMMEDIATE_INTEGER) {
                return new Pair<String, String>(rootNode.getChildren().get(0).getChildren().get(0).getValue(), "");
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER) {
                return new Pair<String, String>(rootNode.getChildren().get(0).getChildren().get(0).getValue(), "");
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER && rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getType() == ExpressionType.IMMEDIATE_INTEGER) {
                return AddressingModeTwoGenerator.offsetImm(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER && rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getType() == ExpressionType.REGISTER) {
                return AddressingModeTwoGenerator.offsetReg(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getValue().equals("LSL")) {
                return AddressingModeTwoGenerator.offsetLSL(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getValue().equals("LSR")) {
                return AddressingModeTwoGenerator.offsetLSR(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getValue().equals("ASR")) {
                return AddressingModeTwoGenerator.offsetASR(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getValue().equals("ROR")) {
                return AddressingModeTwoGenerator.offsetROR(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(1).getValue());
            }
            if (rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getValue().equals("RRX")) {
                return AddressingModeTwoGenerator.offsetRRX(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(0).getChildren().get(1).getChildren().get(0).getValue());
            }
            throw new InternalTranslationException("Error: AddressOperandTypeTwo offset shifter is not valid");
        }
        String string2 = String.valueOf(rootNode.getChildren().get(0).getValue());
        String string3 = String.valueOf(instruction.getMnemonic());
        throw new InternalTranslationException(new StringBuilder(57 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Error: AddressOperandTypeTwo rootNodeValue is not valid ").append(string2).append(" ").append(string3).toString());
    }
}

