/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public final class AddressingModeFourGenerator {
    static final OperandSize wd = OperandSize.WORD;
    static final OperandSize dw = OperandSize.DWORD;
    private static final String matchLDM = "LDM";
    private static final String matchSTM = "STM";

    private AddressingModeFourGenerator() {
    }

    private static String generateDA(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue, String wBit, IOperandTreeNode rootNodeOfRegisterList) {
        String startAddress = environment.getNextVariableString();
        String endAddress = environment.getNextVariableString();
        String tmpStartAddress = environment.getNextVariableString();
        long baseOffset = offset;
        Integer numberOfSetBits = rootNodeOfRegisterList.getChildren().size();
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, registerNodeValue, wd, String.valueOf(numberOfSetBits * 4), dw, tmpStartAddress));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, tmpStartAddress, wd, String.valueOf(4), dw, startAddress));
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, registerNodeValue, dw, endAddress));
        if (wBit.equals("2")) {
            instructions.add(ReilHelpers.createStr(baseOffset++, dw, tmpStartAddress, dw, registerNodeValue));
        }
        return startAddress;
    }

    private static String generateDB(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue, String wBit, IOperandTreeNode rootNodeOfRegisterList) {
        String startAddress = environment.getNextVariableString();
        Integer numberOfSetBits = rootNodeOfRegisterList.getChildren().size();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, registerNodeValue, wd, String.valueOf(numberOfSetBits * 4), dw, startAddress));
        if (wBit.equals("2")) {
            instructions.add(ReilHelpers.createStr(baseOffset++, dw, startAddress, dw, registerNodeValue));
        }
        return startAddress;
    }

    private static String generateIA(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue, String wBit, IOperandTreeNode rootNodeOfRegisterList) {
        String startAddress = environment.getNextVariableString();
        String tmpRegisterVal = environment.getNextVariableString();
        Integer numberOfSetBits = rootNodeOfRegisterList.getChildren().size();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, registerNodeValue, dw, startAddress));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue, wd, String.valueOf(numberOfSetBits * 4), dw, tmpRegisterVal));
        if (wBit.equals("2")) {
            instructions.add(ReilHelpers.createStr(baseOffset++, dw, tmpRegisterVal, dw, registerNodeValue));
        }
        return startAddress;
    }

    private static String generateIB(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue, String wBit, IOperandTreeNode rootNodeOfRegisterList) {
        String startAddress = environment.getNextVariableString();
        String endAddress = environment.getNextVariableString();
        Integer numberOfSetBits = rootNodeOfRegisterList.getChildren().size();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue, dw, String.valueOf(4), dw, startAddress));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, registerNodeValue, dw, String.valueOf(numberOfSetBits * 4), dw, endAddress));
        if (wBit.equals("2")) {
            instructions.add(ReilHelpers.createStr(baseOffset++, dw, endAddress, dw, registerNodeValue));
        }
        return startAddress;
    }

    public static String generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String typeValue, String registerNodeValue, String wBit, IOperandTreeNode rootNodeOfRegisterList) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instruction, "Error: Argument instruction can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        if (typeValue.equals("DA") || typeValue.equals("FA") && instruction.getMnemonic().startsWith(matchLDM) || typeValue.equals("ED") && instruction.getMnemonic().startsWith(matchSTM)) {
            return AddressingModeFourGenerator.generateDA(baseOffset, environment, instructions, registerNodeValue, wBit, rootNodeOfRegisterList);
        }
        if (typeValue.equals("DB") || typeValue.equals("EA") && instruction.getMnemonic().startsWith(matchLDM) || typeValue.equals("FD") && instruction.getMnemonic().startsWith(matchSTM)) {
            return AddressingModeFourGenerator.generateDB(baseOffset, environment, instructions, registerNodeValue, wBit, rootNodeOfRegisterList);
        }
        if (typeValue.equals("IA") || typeValue.equals("FD") && instruction.getMnemonic().startsWith(matchLDM) || typeValue.equals("EA") && instruction.getMnemonic().startsWith(matchSTM)) {
            return AddressingModeFourGenerator.generateIA(baseOffset, environment, instructions, registerNodeValue, wBit, rootNodeOfRegisterList);
        }
        if (typeValue.equals("IB") || typeValue.equals("ED") && instruction.getMnemonic().startsWith(matchLDM) || typeValue.equals("FA") && instruction.getMnemonic().startsWith(matchSTM)) {
            return AddressingModeFourGenerator.generateIB(baseOffset, environment, instructions, registerNodeValue, wBit, rootNodeOfRegisterList);
        }
        String string2 = String.valueOf(typeValue);
        throw new InternalTranslationException(string2.length() != 0 ? "ERROR: there is no such AddressingMode :".concat(string2) : new String("ERROR: there is no such AddressingMode :"));
    }
}

