/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.AddressingModeOneGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class ARMUxtab16Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode shifter = instruction.getOperands().get(2).getRootNode();
        String targetRegister = registerOperand1.getValue();
        String sourceRegister = registerOperand2.getValue();
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String highResult = environment.getNextVariableString();
        String lowResult = environment.getNextVariableString();
        String operand2 = environment.getNextVariableString();
        String operand2from15to0 = environment.getNextVariableString();
        String operand2from31to16 = environment.getNextVariableString();
        String tmpHighResult = environment.getNextVariableString();
        String tmpLowResult = environment.getNextVariableString();
        String tmpRn15to0 = environment.getNextVariableString();
        String tmpRn31to16 = environment.getNextVariableString();
        Pair<String, String> shifterPair = AddressingModeOneGenerator.generate(baseOffset, environment, instruction, instructions, shifter);
        baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String shifterOperand = shifterPair.first();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, shifterOperand, dw, String.valueOf(0xFF00FFL), dw, operand2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, operand2, dw, String.valueOf(65535L), dw, operand2from15to0));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, operand2, dw, String.valueOf(-16L), dw, operand2from31to16));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister, dw, String.valueOf(65535L), dw, tmpRn15to0));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, dw, String.valueOf(-16L), dw, tmpRn31to16));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, operand2from15to0, dw, tmpRn15to0, dw, tmpLowResult));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpLowResult, dw, String.valueOf(65535L), dw, lowResult));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, operand2from31to16, dw, tmpRn31to16, dw, tmpHighResult));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpHighResult, dw, String.valueOf(65535L), dw, highResult));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, highResult, wd, String.valueOf(16L), dw, targetRegister));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, targetRegister, dw, lowResult, dw, targetRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UXTAB16");
        this.translateAll(environment, instruction, "UXTAB16", instructions);
    }
}

