/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMUsat16Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceImmediate = registerOperand2.getValue();
        String sourceRegister = registerOperand3.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String doesUnsignedSat1 = environment.getNextVariableString();
        String doesUnsignedSat2 = environment.getNextVariableString();
        String highResult = environment.getNextVariableString();
        String lowResult = environment.getNextVariableString();
        String tmpHighResult = environment.getNextVariableString();
        String tmpLowResult = environment.getNextVariableString();
        String tmpRm15to0 = environment.getNextVariableString();
        String tmpRm32to16 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister, dw, String.valueOf(65535L), wd, tmpRm15to0));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, wd, String.valueOf(-16L), wd, tmpRm32to16));
        Helpers.unsignedSat(baseOffset, environment, instruction, instructions, tmpRm15to0, tmpRm15to0, tmpRm15to0, "", tmpLowResult, Integer.decode(sourceImmediate).intValue(), doesUnsignedSat1);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Helpers.unsignedSat(baseOffset, environment, instruction, instructions, tmpRm32to16, tmpRm32to16, tmpRm32to16, "", tmpHighResult, Integer.decode(sourceImmediate).intValue(), doesUnsignedSat2);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpLowResult, dw, String.valueOf(65535L), dw, lowResult));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpHighResult, dw, String.valueOf(65535L), dw, tmpHighResult));
        instructions.add(ReilHelpers.createBsh(baseOffset++, wd, tmpHighResult, wd, String.valueOf(16), dw, highResult));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, highResult, dw, lowResult, dw, targetRegister));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, doesUnsignedSat1, bt2, doesUnsignedSat2, bt2, "Q"));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "USAT16");
        this.translateAll(environment, instruction, "USAT16", instructions);
    }
}

