/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.reil.translators.arm.Processor;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMUqsubaddxTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(final ITranslationEnvironment environment, final IInstruction instruction, final List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        new Processor(){

            @Override
            protected String[] process(long baseOffset, String[] firstTwo, String[] secondTwo) {
                String diff1 = environment.getNextVariableString();
                String sum1 = environment.getNextVariableString();
                String diff1Sat = environment.getNextVariableString();
                String sum1Sat = environment.getNextVariableString();
                instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstTwo[0], dw, secondTwo[1], dw, sum1));
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, firstTwo[1], dw, secondTwo[0], dw, diff1));
                Helpers.unsignedSat(baseOffset, environment, instruction, instructions, firstTwo[0], secondTwo[1], sum1, "ADD", sum1Sat, 16L, "");
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.unsignedSat(baseOffset, environment, instruction, instructions, firstTwo[1], secondTwo[0], diff1, "SUB", diff1Sat, 16L, "");
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                return new String[]{sum1Sat, diff1Sat};
            }
        }.generate(environment, baseOffset, 16, sourceRegister1, sourceRegister2, targetRegister, instructions);
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        if (instruction.getMnemonic().startsWith("UQSAX")) {
            TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UQSAX");
            this.translateAll(environment, instruction, "UQSAX", instructions);
        } else {
            TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UQSUBADDX");
            this.translateAll(environment, instruction, "UQSUBADDX", instructions);
        }
    }
}

