/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.reil.translators.arm.Processor;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMSsub8Translator
extends ARMBaseTranslator {
    @Override
    protected final void translateCore(final ITranslationEnvironment environment, final IInstruction instruction, final List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        final OperandSize bt2 = OperandSize.BYTE;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        new Processor(){

            @Override
            protected String[] process(long offset, String[] firstFour, String[] secondFour) {
                String tmpResult1 = environment.getNextVariableString();
                String tmpResult1Not = environment.getNextVariableString();
                String tmpResult2 = environment.getNextVariableString();
                String tmpResult2Not = environment.getNextVariableString();
                String tmpResult3 = environment.getNextVariableString();
                String tmpResult3Not = environment.getNextVariableString();
                String tmpResult4 = environment.getNextVariableString();
                String tmpResult4Not = environment.getNextVariableString();
                String trueResult1 = environment.getNextVariableString();
                String trueResult2 = environment.getNextVariableString();
                String trueResult3 = environment.getNextVariableString();
                String trueResult4 = environment.getNextVariableString();
                long baseOffset = offset;
                Helpers.signedSub(baseOffset, environment, instruction, instructions, secondFour[0], firstFour[0], tmpResult1, trueResult1);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signedSub(baseOffset, environment, instruction, instructions, secondFour[1], firstFour[1], tmpResult2, trueResult2);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signedSub(baseOffset, environment, instruction, instructions, secondFour[2], firstFour[2], tmpResult3, trueResult3);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signedSub(baseOffset, environment, instruction, instructions, secondFour[3], firstFour[3], tmpResult4, trueResult4);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                instructions.add(ReilHelpers.createXor(baseOffset++, dw, trueResult1, dw, String.valueOf(255L), dw, tmpResult1Not));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpResult1Not, dw, String.valueOf(-7L), bt2, "CPSR_GE_0"));
                instructions.add(ReilHelpers.createXor(baseOffset++, dw, trueResult2, dw, String.valueOf(255L), dw, tmpResult2Not));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpResult2Not, dw, String.valueOf(-7L), bt2, "CPSR_GE_1"));
                instructions.add(ReilHelpers.createXor(baseOffset++, dw, trueResult3, dw, String.valueOf(255L), dw, tmpResult3Not));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpResult3Not, dw, String.valueOf(-7L), bt2, "CPSR_GE_2"));
                instructions.add(ReilHelpers.createXor(baseOffset++, dw, trueResult4, dw, String.valueOf(255L), dw, tmpResult4Not));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpResult4Not, dw, String.valueOf(-7L), bt2, "CPSR_GE_3"));
                return new String[]{tmpResult1, tmpResult2, tmpResult3, tmpResult4};
            }
        }.generate(environment, baseOffset, 8, sourceRegister1, sourceRegister2, targetRegister, instructions);
    }

    @Override
    public final void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SSUB8");
        this.translateAll(environment, instruction, "SSUB8", instructions);
    }
}

