/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.reil.translators.arm.Processor;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMSsub16Translator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(final ITranslationEnvironment environment, final IInstruction instruction, final List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        final OperandSize bt2 = OperandSize.BYTE;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        new Processor(){

            @Override
            protected int getResultShiftDelta() {
                return 0;
            }

            @Override
            protected String[] process(long offset, String[] firstTwo, String[] secondTwo) {
                String diff1 = environment.getNextVariableString();
                String diff2 = environment.getNextVariableString();
                String trueDiff1 = environment.getNextVariableString();
                String trueDiff2 = environment.getNextVariableString();
                String tmpVar1 = environment.getNextVariableString();
                String tmpVar2 = environment.getNextVariableString();
                long baseOffset = offset;
                Helpers.signedSub(baseOffset, environment, instruction, instructions, secondTwo[0], firstTwo[0], diff1, trueDiff1);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                Helpers.signedSub(baseOffset, environment, instruction, instructions, secondTwo[1], firstTwo[1], diff2, trueDiff2);
                baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
                instructions.add(ReilHelpers.createXor(baseOffset++, dw, trueDiff1, dw, String.valueOf(65535L), dw, tmpVar1));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar1, dw, String.valueOf(-15L), bt2, "CPSR_GE_0"));
                instructions.add(ReilHelpers.createStr(baseOffset++, bt2, "CPSR_GE_0", bt2, "CPSR_GE_1"));
                instructions.add(ReilHelpers.createXor(baseOffset++, dw, trueDiff2, dw, String.valueOf(65535L), dw, tmpVar2));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpVar2, dw, String.valueOf(-15L), bt2, "CPSR_GE_2"));
                instructions.add(ReilHelpers.createStr(baseOffset++, bt2, "CPSR_GE_2", bt2, "CPSR_GE_3"));
                return new String[]{diff1, diff2};
            }
        }.generate(environment, baseOffset, 16, sourceRegister1, sourceRegister2, targetRegister, instructions);
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SSUB16");
        this.translateAll(environment, instruction, "SSUB16", instructions);
    }
}

