/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMSmulXYTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String operand1 = environment.getNextVariableString();
        String operand2 = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        if (instruction.getMnemonic().contains("BB")) {
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, sourceRegister1, dw, operand1, 16);
            baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, sourceRegister2, dw, operand2, 16);
        } else if (instruction.getMnemonic().contains("BT")) {
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, sourceRegister1, dw, operand1, 16);
            baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister2, wd, String.valueOf(-16L), dw, tmpVar1));
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, tmpVar1, dw, operand2, 16);
        } else if (instruction.getMnemonic().contains("TB")) {
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister1, wd, String.valueOf(-16L), dw, tmpVar1));
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, tmpVar1, dw, operand1, 16);
            baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, sourceRegister2, dw, operand2, 16);
        } else if (instruction.getMnemonic().contains("TB")) {
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister1, wd, String.valueOf(-16L), dw, tmpVar1));
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, tmpVar1, dw, operand1, 16);
            baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister2, wd, String.valueOf(-16L), dw, tmpVar2));
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, tmpVar2, dw, operand2, 16);
        }
        instructions.add(ReilHelpers.createMul(baseOffset++, dw, operand1, dw, operand2, qw, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar3, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SMUL");
        this.translateAll(environment, instruction, "SMUL", instructions);
    }
}

