/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMSmlsdTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand4 = instruction.getOperands().get(3).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister1 = registerOperand2.getValue();
        String sourceRegister2 = registerOperand3.getValue();
        String sourceRegister3 = registerOperand4.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        OperandSize wd = OperandSize.WORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String operand2 = environment.getNextVariableString();
        String tmpRotate1 = environment.getNextVariableString();
        String tmpRotate2 = environment.getNextVariableString();
        String diffOfProducts = environment.getNextVariableString();
        String operand2from15to0 = environment.getNextVariableString();
        String operand2from31to16 = environment.getNextVariableString();
        String registerRmfrom15to0 = environment.getNextVariableString();
        String registerRmfrom31to16 = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String trueDiffOfProducts = environment.getNextVariableString();
        String product1 = environment.getNextVariableString();
        String product2 = environment.getNextVariableString();
        if (instruction.getMnemonic().contains("X")) {
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister2, bt2, String.valueOf(-16), dw, tmpRotate1));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister2, bt2, String.valueOf(16), dw, tmpRotate2));
            instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpRotate1, dw, tmpRotate2, dw, operand2));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, operand2, dw, String.valueOf(0xFFFFFFFFL), dw, operand2));
        } else {
            instructions.add(ReilHelpers.createStr(baseOffset++, dw, sourceRegister2, dw, operand2));
        }
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, operand2, dw, String.valueOf(65535L), dw, operand2from15to0));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister1, dw, String.valueOf(65535L), dw, registerRmfrom15to0));
        Helpers.signedMul(baseOffset, environment, instruction, instructions, wd, operand2from15to0, wd, registerRmfrom15to0, dw, product1);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, operand2, dw, String.valueOf(-16L), dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, String.valueOf(65535L), dw, operand2from31to16));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister1, dw, String.valueOf(-16L), dw, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar2, dw, String.valueOf(65535L), dw, registerRmfrom31to16));
        Helpers.signedMul(baseOffset, environment, instruction, instructions, wd, operand2from31to16, wd, registerRmfrom31to16, dw, product2);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Helpers.signedSub(baseOffset, environment, instruction, instructions, product2, product1, diffOfProducts, trueDiffOfProducts);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, sourceRegister3, dw, diffOfProducts, dw, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar3, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister));
        Helpers.overflowCondition(baseOffset, environment, instruction, instructions, tmpVar3);
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SMLSD");
        this.translateAll(environment, instruction, "SMLSD", instructions);
    }
}

