/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMSmlawYTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand4 = instruction.getOperands().get(3).getRootNode().getChildren().get(0);
        String sourceRegister1 = registerOperand1.getValue();
        String sourceRegister2 = registerOperand2.getValue();
        String sourceRegister3 = registerOperand3.getValue();
        String sourceRegister4 = registerOperand4.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        String isNotOverflowed = environment.getNextVariableString();
        String operand2 = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String tmpVar5 = environment.getNextVariableString();
        String tmpVar6 = environment.getNextVariableString();
        String tmpVar7 = environment.getNextVariableString();
        String tmpResult = environment.getNextVariableString();
        if (instruction.getMnemonic().contains("B")) {
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, sourceRegister3, dw, operand2, 16);
            baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        } else if (instruction.getMnemonic().contains("T")) {
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister3, wd, String.valueOf(-16L), dw, tmpVar1));
            Helpers.signExtend(baseOffset, environment, instruction, instructions, dw, tmpVar1, dw, operand2, 16);
            baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        }
        Helpers.signedMul(baseOffset, environment, instruction, instructions, dw, operand2, dw, sourceRegister2, qw, tmpResult);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpVar3, wd, String.valueOf(-16L), dw, tmpVar4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar4, dw, String.valueOf(0xFFFFFFFFL), dw, tmpVar5));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, sourceRegister4, dw, tmpVar5, qw, tmpVar6));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar6, dw, String.valueOf(0xFFFFFFFFL), dw, sourceRegister1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpVar6, wd, String.valueOf(-32), dw, tmpVar7));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dw, tmpVar7, bt2, isNotOverflowed));
        instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, isNotOverflowed, bt2, "Q"));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SMLAW");
        this.translateAll(environment, instruction, "SMLAW", instructions);
    }
}

