/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class ARMSmlaldTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand4 = instruction.getOperands().get(3).getRootNode().getChildren().get(0);
        String sourceRegister1 = registerOperand1.getValue();
        String sourceRegister2 = registerOperand2.getValue();
        String sourceRegister3 = registerOperand3.getValue();
        String sourceRegister4 = registerOperand4.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String accValue = environment.getNextVariableString();
        String operand2 = environment.getNextVariableString();
        String operand2from15to0 = environment.getNextVariableString();
        String operand2from31to16 = environment.getNextVariableString();
        String registerRm15to0 = environment.getNextVariableString();
        String registerRm31to16 = environment.getNextVariableString();
        String tmpAccValue = environment.getNextVariableString();
        String tmpResult1 = environment.getNextVariableString();
        String tmpResult2 = environment.getNextVariableString();
        String tmpResult3 = environment.getNextVariableString();
        String tmpRotate1 = environment.getNextVariableString();
        String tmpRotate2 = environment.getNextVariableString();
        String product1 = environment.getNextVariableString();
        String product2 = environment.getNextVariableString();
        if (instruction.getMnemonic().contains("X")) {
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister4, bt2, String.valueOf(-16), dw, tmpRotate1));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister4, bt2, String.valueOf(16), dw, tmpRotate2));
            instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpRotate1, dw, tmpRotate2, dw, operand2));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, operand2, dw, String.valueOf(0xFFFFFFFFL), dw, operand2));
        } else {
            instructions.add(ReilHelpers.createStr(baseOffset++, dw, sourceRegister4, dw, operand2));
        }
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, sourceRegister1, qw, accValue));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister2, wd, String.valueOf(32L), qw, tmpAccValue));
        instructions.add(ReilHelpers.createOr(baseOffset++, qw, tmpAccValue, dw, accValue, qw, accValue));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, operand2, dw, String.valueOf(65535L), dw, operand2from15to0));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, operand2, dw, String.valueOf(-16L), dw, operand2from31to16));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister3, dw, String.valueOf(65535L), dw, registerRm15to0));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister3, dw, String.valueOf(-16L), dw, registerRm31to16));
        Helpers.signedMul(baseOffset, environment, instruction, instructions, wd, registerRm15to0, wd, operand2from15to0, dw, product1);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        Helpers.signedMul(baseOffset, environment, instruction, instructions, wd, registerRm31to16, wd, operand2from31to16, dw, product2);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, product1, dw, product2, qw, tmpResult1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpResult1, dw, String.valueOf(0xFFFFFFFFL), dw, tmpResult1));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, tmpResult1, qw, accValue, qw, tmpResult2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpResult2, dw, String.valueOf(0xFFFFFFFFL), dw, sourceRegister1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpResult2, qw, String.valueOf(-4294967296L), qw, tmpResult3));
        instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpResult3, dw, String.valueOf(-32L), dw, sourceRegister2));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SMLALD");
        this.translateAll(environment, instruction, "SMLALD", instructions);
    }
}

